/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.multiregattalist;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.regatta.RegattaWithProgressDTO;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaList;
import com.sap.sailing.gwt.home.desktop.partials.multiregattalist.MultiRegattaListItem;
import com.sap.sailing.gwt.home.desktop.places.event.multiregatta.EventMultiregattaView;
import com.sap.sailing.gwt.home.shared.partials.placeholder.InfoPlaceholder;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.dispatch.shared.commands.SortedSetResult;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public class MultiRegattaList
extends Composite
implements RefreshableWidget<SortedSetResult<RegattaWithProgressDTO>> {
    private static MultiRegattaListUiBinder uiBinder = (MultiRegattaListUiBinder)GWT.create(MultiRegattaListUiBinder.class);
    @UiField
    FlowPanel regattasContainerUi;
    private final EventMultiregattaView.Presenter currentPresenter;
    private final Collection<String> selectableBoatCategories = new TreeSet();
    private final boolean showMessageIfEmpty;
    private boolean hasData = false;

    public MultiRegattaList(EventMultiregattaView.Presenter presenter, boolean showMessageIfEmpty) {
        this.currentPresenter = presenter;
        this.showMessageIfEmpty = showMessageIfEmpty;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void setData(SortedSetResult<RegattaWithProgressDTO> data) {
        this.setListData((Collection)(data == null ? Collections.emptySet() : data.getValues()));
    }

    public void setListData(Collection<RegattaWithProgressDTO> data) {
        this.regattasContainerUi.clear();
        this.selectableBoatCategories.clear();
        boolean bl = this.hasData = !data.isEmpty();
        if (!this.hasData && this.showMessageIfEmpty) {
            this.regattasContainerUi.add((Widget)new InfoPlaceholder(StringMessages.INSTANCE.noDataForEvent()));
        }
        for (RegattaWithProgressDTO regattaWithProgress : data) {
            this.regattasContainerUi.add((Widget)new MultiRegattaListItem(regattaWithProgress, this.currentPresenter));
            Iterable leaderboardGroupNames = regattaWithProgress.getLeaderboardGroupNames();
            if (leaderboardGroupNames == null) continue;
            Util.addAll((Iterable)leaderboardGroupNames, (Collection)this.selectableBoatCategories);
        }
    }

    public Collection<String> getSelectableBoatCategories() {
        return this.selectableBoatCategories;
    }

    public void setVisibleLeaderboardGroup(String leaderboardGroupName) {
        if (!this.hasData) {
            return;
        }
        int i = 0;
        while (i < this.regattasContainerUi.getWidgetCount()) {
            MultiRegattaListItem item = (MultiRegattaListItem)this.regattasContainerUi.getWidget(i);
            item.setVisibilityDependingOnLeaderboardGroup(leaderboardGroupName);
            ++i;
        }
    }
}

