/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.eventlist;

import com.google.gwt.core.shared.GwtIncompatible;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;

public class EventListYearDTO
implements IsSerializable {
    private int year;
    private int eventCount;
    private int numberOfCompetitors;
    private int numberOfRegattas;
    private int numberOfRaces;
    private int numberOfTrackedRaces;
    private long numberOfGPSFixes;
    private long numberOfWindFixes;
    private Distance distanceTraveled;
    private SimpleCompetitorDTO fastestCompetitor;
    private Double fastestCompetitorSpeedInKnots;
    private ArrayList<EventListEventDTO> events = new ArrayList();

    private EventListYearDTO() {
    }

    public EventListYearDTO(int year) {
        this.year = year;
    }

    public int getYear() {
        return this.year;
    }

    public List<EventListEventDTO> getEvents() {
        return this.events;
    }

    @GwtIncompatible
    protected void addEvent(EventListEventDTO event) {
        this.eventCount += event.getEventSeries() == null ? 1 : event.getEventSeries().getEventsCount();
        int i = 0;
        while (i < this.events.size()) {
            if (this.isEventBeforeOtherInList(event, (EventListEventDTO)this.events.get(i))) {
                this.events.add(i, event);
                return;
            }
            ++i;
        }
        this.events.add(event);
    }

    private boolean isEventBeforeOtherInList(EventListEventDTO eventTocheck, EventListEventDTO referenceEvent) {
        if (eventTocheck.isRunning() && !referenceEvent.isRunning()) {
            return true;
        }
        if (!eventTocheck.isRunning() && referenceEvent.isRunning()) {
            return false;
        }
        return referenceEvent.getStartDate().before(eventTocheck.getStartDate());
    }

    @GwtIncompatible
    protected void addStatistics(Statistics statistics) {
        this.numberOfCompetitors = statistics.getNumberOfCompetitors();
        this.numberOfRegattas = statistics.getNumberOfRegattas();
        this.numberOfRaces = statistics.getNumberOfRaces();
        this.numberOfTrackedRaces = statistics.getNumberOfTrackedRaces();
        this.numberOfGPSFixes = statistics.getNumberOfGPSFixes();
        this.numberOfWindFixes = statistics.getNumberOfWindFixes();
        this.distanceTraveled = statistics.getDistanceTraveled();
        Util.Triple maxSpeed = statistics.getMaxSpeed();
        if (maxSpeed != null) {
            this.fastestCompetitor = new SimpleCompetitorDTO((Competitor)maxSpeed.getA());
            this.fastestCompetitorSpeedInKnots = ((Speed)maxSpeed.getB()).getKnots();
        }
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getNumberOfCompetitors() {
        return this.numberOfCompetitors;
    }

    public int getNumberOfRegattas() {
        return this.numberOfRegattas;
    }

    public int getNumberOfRaces() {
        return this.numberOfRaces;
    }

    public int getNumberOfTrackedRaces() {
        return this.numberOfTrackedRaces;
    }

    public long getNumberOfGPSFixes() {
        return this.numberOfGPSFixes;
    }

    public long getNumberOfWindFixes() {
        return this.numberOfWindFixes;
    }

    public Distance getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public SimpleCompetitorDTO getFastestCompetitor() {
        return this.fastestCompetitor;
    }

    public Double getFastestCompetitorSpeedInKnots() {
        return this.fastestCompetitorSpeedInKnots;
    }
}

