/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mail;

import com.sap.sse.mail.SerializableMimeBodyPartSupplier;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;

public class SerializableFileMimeBodyPartSupplier
implements SerializableMimeBodyPartSupplier {
    private static final long serialVersionUID = 4259007918955254014L;
    private final byte[] bytes;
    private final String contentType;
    private final String contentId;
    private final String disposition;

    public SerializableFileMimeBodyPartSupplier(byte[] bytes, String contentType, String filename) {
        this(bytes, contentType, null, filename, "attachment");
    }

    public SerializableFileMimeBodyPartSupplier(byte[] bytes, String contentType, String contentId, String filename) {
        this(bytes, contentType, contentId, filename, "inline");
    }

    private SerializableFileMimeBodyPartSupplier(byte[] bytes, String contentType, String contentId, String filename, String presentedAs) {
        this.bytes = bytes;
        this.contentType = contentType;
        this.contentId = contentId;
        this.disposition = String.valueOf(presentedAs) + ";filename=\"" + filename + "\"";
    }

    @Override
    public MimeBodyPart get() {
        MimeBodyPart messageImagePart = new MimeBodyPart();
        ByteArrayDataSource imageDs = new ByteArrayDataSource(this.bytes, this.contentType);
        try {
            messageImagePart.setDataHandler(new DataHandler((DataSource)imageDs));
            messageImagePart.setContentID(this.contentId);
            messageImagePart.setDisposition(this.disposition);
            return messageImagePart;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

