/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.server.gateway.serialization.impl.BoatJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class CompetitorAndBoatJsonSerializer
implements JsonSerializer<Util.Pair<Competitor, Boat>> {
    private static final Logger logger = Logger.getLogger(CompetitorAndBoatJsonSerializer.class.getName());
    private final JsonSerializer<Competitor> competitorJsonSerializer;
    private final JsonSerializer<Boat> boatJsonSerializer;
    public static final String FIELD_BOAT = "boat";
    public static final String FIELD_COMPETITOR = "competitor";

    public static CompetitorAndBoatJsonSerializer create(boolean serializeNonPublicCompetitorFields) {
        return new CompetitorAndBoatJsonSerializer(CompetitorJsonSerializer.create(true, serializeNonPublicCompetitorFields), BoatJsonSerializer.create());
    }

    public CompetitorAndBoatJsonSerializer(JsonSerializer<Competitor> competitorJsonSerializer, JsonSerializer<Boat> boatJsonSerializer) {
        this.competitorJsonSerializer = competitorJsonSerializer;
        this.boatJsonSerializer = boatJsonSerializer;
    }

    public JSONObject serialize(Util.Pair<Competitor, Boat> competitorAndBoat) {
        JSONObject result;
        boolean compatibilityMode;
        JSONObject serializedCompetitor = this.competitorJsonSerializer.serialize((Object)((Competitor)competitorAndBoat.getA()));
        if (((Competitor)competitorAndBoat.getA()).hasBoat()) {
            CompetitorWithBoat competitorWithBoat = (CompetitorWithBoat)competitorAndBoat.getA();
            Boat boat = competitorWithBoat.getBoat();
            if (boat != competitorAndBoat.getB()) {
                logger.warning("Competitor " + competitorWithBoat + " has boat " + boat + " which is different from the boat to be serialized with it (" + competitorAndBoat.getB());
                compatibilityMode = false;
            } else {
                compatibilityMode = true;
            }
        } else {
            compatibilityMode = false;
        }
        if (compatibilityMode) {
            result = serializedCompetitor;
        } else {
            JSONObject serializedBoat = competitorAndBoat.getB() == null ? null : this.boatJsonSerializer.serialize((Object)((Boat)competitorAndBoat.getB()));
            result = new JSONObject();
            result.put((Object)FIELD_COMPETITOR, (Object)serializedCompetitor);
            result.put((Object)FIELD_BOAT, (Object)serializedBoat);
        }
        return result;
    }
}

