/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Arrays;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BoatClassJsonSerializer
implements JsonSerializer<BoatClass> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TYPICALLY_STARTS_UPWIND = "typicallyStartsUpwind";
    public static final String FIELD_HULL_LENGTH_IN_METERS = "hullLengthInMeters";
    public static final String FIELD_HULL_BEAM_IN_METERS = "hullBeamInMeters";
    public static final String FIELD_DISPLAY_NAME = "displayName";
    public static final String FIELD_ALIAS_NAMES = "aliasNames";
    public static final String FIELD_ICON_URL = "iconUrl";
    private final boolean verbose;

    public BoatClassJsonSerializer() {
        this(true);
    }

    public BoatClassJsonSerializer(boolean verbose) {
        this.verbose = verbose;
    }

    public JSONObject serialize(BoatClass boatClass) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)boatClass.getName());
        result.put((Object)FIELD_TYPICALLY_STARTS_UPWIND, (Object)boatClass.typicallyStartsUpwind());
        if (boatClass.getHullLength() != null) {
            result.put((Object)FIELD_HULL_LENGTH_IN_METERS, (Object)boatClass.getHullLength().getMeters());
        }
        if (this.verbose) {
            if (boatClass.getHullBeam() != null) {
                result.put((Object)FIELD_HULL_BEAM_IN_METERS, (Object)boatClass.getHullBeam().getMeters());
            }
            JSONArray aliasNames = new JSONArray();
            if (boatClass.getName() != null) {
                result.put((Object)FIELD_DISPLAY_NAME, (Object)boatClass.getName());
                BoatClassMasterdata masterData = BoatClassMasterdata.resolveBoatClass((String)boatClass.getName());
                if (masterData != null) {
                    result.put((Object)FIELD_ICON_URL, (Object)("/gwt/src/main/resources/com/sap/sailing/gwt/ui/client/images/boatclass/" + masterData.name().replaceAll("^_", "") + ".png"));
                    aliasNames.addAll(Arrays.asList(masterData.getAlternativeNames()));
                }
            }
            result.put((Object)FIELD_ALIAS_NAMES, (Object)aliasNames);
        }
        return result;
    }
}

