/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.coursedata.impl;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.server.gateway.serialization.coursedata.impl.BaseControlPointJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class MarkJsonSerializer
extends BaseControlPointJsonSerializer
implements JsonSerializer<ControlPoint> {
    public static final String VALUE_CLASS = Mark.class.getSimpleName();
    public static final String FIELD_ID = "id";
    public static final String FIELD_COLOR = "color";
    public static final String FIELD_PATTERN = "pattern";
    public static final String FIELD_SHAPE = "shape";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_SHORT_NAME = "shortName";
    public static final String FIELD_ORIGINATING_MARK_TEMPLATE_ID = "originatingMarkTemplateId";
    public static final String FIELD_ORIGINATING_MARK_PROPERTIES_ID = "originatingMarkPropertiesId";

    @Override
    protected String getClassFieldValue() {
        return VALUE_CLASS;
    }

    @Override
    public JSONObject serialize(ControlPoint object) {
        Mark mark = (Mark)object;
        JSONObject result = super.serialize((ControlPoint)mark);
        result.put((Object)FIELD_ID, (Object)mark.getId().toString());
        if (mark.getColor() != null) {
            result.put((Object)FIELD_COLOR, (Object)mark.getColor().getAsHtml());
        }
        if (mark.getPattern() != null) {
            result.put((Object)FIELD_PATTERN, (Object)mark.getPattern());
        }
        if (mark.getShape() != null) {
            result.put((Object)FIELD_SHAPE, (Object)mark.getShape());
        }
        if (mark.getType() != null) {
            result.put((Object)FIELD_TYPE, (Object)mark.getType().name());
        }
        if (mark.getShortName() != null) {
            result.put((Object)FIELD_SHORT_NAME, (Object)mark.getShortName());
        }
        if (mark.getOriginatingMarkTemplateIdOrNull() != null) {
            result.put((Object)FIELD_ORIGINATING_MARK_TEMPLATE_ID, (Object)mark.getOriginatingMarkTemplateIdOrNull().toString());
        }
        if (mark.getOriginatingMarkPropertiesIdOrNull() != null) {
            result.put((Object)FIELD_ORIGINATING_MARK_PROPERTIES_ID, (Object)mark.getOriginatingMarkPropertiesIdOrNull().toString());
        }
        return result;
    }
}

