/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.impl.PlaceHolderDeviceIdentifierJsonHandler;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.impl.SingleTypeBasedServiceFinderImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import org.json.simple.JSONObject;

public class DeviceIdentifierJsonDeserializer
implements JsonDeserializer<DeviceIdentifier> {
    public static final String FIELD_DEVICE_ID = "id";
    public static final String FIELD_DEVICE_TYPE = "type";
    public static final String FIELD_STRING_REPRESENTATION = "stringRepresentation";
    private final TypeBasedServiceFinder<DeviceIdentifierJsonHandler> deviceServiceFinder;

    public static DeviceIdentifierJsonDeserializer create(DeviceIdentifierJsonHandler singleHandler, String type) {
        return new DeviceIdentifierJsonDeserializer((TypeBasedServiceFinder<DeviceIdentifierJsonHandler>)new SingleTypeBasedServiceFinderImpl((Object)singleHandler, (Object)new PlaceHolderDeviceIdentifierJsonHandler(), type));
    }

    public DeviceIdentifierJsonDeserializer(TypeBasedServiceFinder<DeviceIdentifierJsonHandler> deviceServiceFinder) {
        this.deviceServiceFinder = deviceServiceFinder;
    }

    public DeviceIdentifier deserialize(JSONObject object) throws JsonDeserializationException {
        Object deviceIdObject = object.get((Object)FIELD_DEVICE_ID);
        String deviceType = (String)object.get((Object)FIELD_DEVICE_TYPE);
        String deviceStringRep = (String)object.get((Object)FIELD_STRING_REPRESENTATION);
        try {
            return ((DeviceIdentifierJsonHandler)this.deviceServiceFinder.findService(deviceType)).deserialize(deviceIdObject, deviceType, deviceStringRep);
        }
        catch (TransformationException e) {
            try {
                return new PlaceHolderDeviceIdentifierJsonHandler().deserialize(deviceIdObject, deviceType, deviceStringRep);
            }
            catch (TransformationException e2) {
                throw new JsonDeserializationException((Throwable)e2);
            }
        }
    }
}

