/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.store;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.exception.ModelNotFoundException;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.AbstractModelStoreImpl;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategy;
import com.sap.sailing.windestimation.model.store.PersistableModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileSystemModelStoreImpl
extends AbstractModelStoreImpl {
    private final String destinationFolder;

    public FileSystemModelStoreImpl(String destinationFolder) {
        this.destinationFolder = destinationFolder;
        File folder = new File(destinationFolder);
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private File getFileForModel(PersistableModel<?, ?> persistableModel) {
        return this.getFileForModel(this.getPersistenceKey(persistableModel));
    }

    private File getFileForModel(String filename) {
        StringBuilder filePath = new StringBuilder();
        filePath.append(this.destinationFolder);
        filePath.append(File.separator);
        filePath.append(filename);
        String finalFilePath = filePath.toString();
        return new File(finalFilePath);
    }

    @Override
    public <InstanceType, T extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, T>> ModelType loadModel(ModelType untrainedModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(untrainedModel);
        File modelFile = this.getFileForModel(untrainedModel);
        if (modelFile.exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream input = new FileInputStream(modelFile);){
                    TrainableModel loadedModel = (TrainableModel)serializationStrategy.deserializeFromStream(input);
                    if (!((ModelContext)untrainedModel.getModelContext()).equals(loadedModel.getModelContext())) {
                        throw new ModelPersistenceException("The configuration of the loaded model is: " + loadedModel.getModelContext() + ". \nExpected: " + untrainedModel.getModelContext());
                    }
                    return (ModelType)loadedModel;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ModelPersistenceException(e);
            }
        }
        throw new ModelNotFoundException((ModelContext<?>)untrainedModel.getModelContext());
    }

    @Override
    public void persistModel(PersistableModel<?, ?> trainedModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(trainedModel);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream output = new FileOutputStream(this.getFileForModel(trainedModel));){
                serializationStrategy.serializeToStream(trainedModel, output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ModelPersistenceException(e);
        }
    }

    public <T extends PersistableModel<?, ?>> void delete(T newModel) throws ModelPersistenceException {
        this.checkAndGetModelSerializationStrategy(newModel);
        File modelFile = this.getFileForModel(newModel);
        try {
            Files.deleteIfExists(modelFile.toPath());
        }
        catch (IOException e) {
            throw new ModelPersistenceException(e);
        }
    }

    @Override
    public void deleteAll(ModelDomainType domainType) throws ModelPersistenceException {
        File folder = new File(this.destinationFolder);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().endsWith(".clf") && file.getName().startsWith(this.getPersistenceKeyPartOfModelDomain(domainType))) {
                try {
                    Files.deleteIfExists(file.toPath());
                }
                catch (IOException e) {
                    throw new ModelPersistenceException(e);
                }
            }
            ++n2;
        }
    }

    @Override
    public Map<String, byte[]> exportAllPersistedModels(ModelDomainType domainType) throws ModelPersistenceException {
        HashMap<String, byte[]> exportedModels = new HashMap<String, byte[]>();
        File folder = new File(this.destinationFolder);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isFile() && this.isPersistenceKeyBelongingToModelDomain(fileName, domainType)) {
                byte[] exportedModel;
                try {
                    exportedModel = Files.readAllBytes(file.toPath());
                }
                catch (IOException e) {
                    throw new ModelPersistenceException("Could not read model \"" + fileName + "\" from filesystem", e);
                }
                exportedModels.put(fileName, exportedModel);
            }
            ++n2;
        }
        return exportedModels;
    }

    @Override
    public void importPersistedModels(Map<String, byte[]> exportedPersistedModels, ModelDomainType domainType) throws ModelPersistenceException {
        for (Map.Entry<String, byte[]> entry : exportedPersistedModels.entrySet()) {
            String fileName = entry.getKey();
            byte[] exportedModel = entry.getValue();
            Path modelPath = Paths.get(this.destinationFolder, fileName);
            try {
                Files.write(modelPath, exportedModel, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new ModelPersistenceException("Could not store model \"" + fileName + "\" on filesystem", e);
            }
        }
    }

    @Override
    public List<PersistableModel<?, ?>> loadAllPersistedModels(ModelDomainType domainType) {
        ArrayList loadedModels = new ArrayList();
        File folder = new File(this.destinationFolder);
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file.isFile() && this.isPersistenceKeyBelongingToModelDomain(fileName, domainType)) {
                PersistableModel<?, ?> loadedModel;
                ModelSerializationStrategy serializationStrategy = this.getModelSerializationStrategyFromPersistenceKey(fileName);
                if (serializationStrategy == null) {
                    throw new ModelLoadingException("Persistence support could not be determined due to invalid filename pattern: \"" + fileName + "\"");
                }
                File modelFile = this.getFileForModel(fileName);
                try {
                    Throwable throwable = null;
                    Object var13_15 = null;
                    try (FileInputStream input = new FileInputStream(modelFile);){
                        loadedModel = serializationStrategy.deserializeFromStream(input);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new ModelLoadingException("Could not read model \"" + fileName + "\" from filesystem", e);
                }
                loadedModels.add(loadedModel);
            }
            ++n2;
        }
        return loadedModels;
    }
}

