/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.polarsfitting;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.base.impl.SpeedWithBearingWithConfidenceImpl;
import com.sap.sailing.domain.base.impl.SpeedWithConfidenceImpl;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sailing.windestimation.aggregator.polarsfitting.CoarseGrainedPointOfSail;
import com.sap.sailing.windestimation.aggregator.polarsfitting.FineGrainedPointOfSail;
import com.sap.sailing.windestimation.aggregator.polarsfitting.SpeedStatistics;
import com.sap.sailing.windestimation.aggregator.polarsfitting.WindSpeedRange;
import com.sap.sailing.windestimation.data.CompetitorTrackWithEstimationData;
import com.sap.sailing.windestimation.data.ManeuverForEstimation;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolarsFittingWindEstimation {
    private static final int COURSE_CLUSTER_SIZE = 10;
    private final PolarDataService polarService;
    private final Map<BoatClass, SpeedStatistics[]> speedsPerBoatClass = new HashMap<BoatClass, SpeedStatistics[]>();

    public PolarsFittingWindEstimation(PolarDataService polarService) {
        this.polarService = polarService;
    }

    public PolarsFittingWindEstimation(PolarDataService polarService, List<CompetitorTrackWithEstimationData<ManeuverForEstimation>> competitorTracks) {
        this(polarService);
        for (CompetitorTrackWithEstimationData<ManeuverForEstimation> competitorTrack : competitorTracks) {
            for (ManeuverForEstimation maneuver : competitorTrack.getElements()) {
                if (!maneuver.isClean()) continue;
                this.addSpeedWithCourseRecord(maneuver.getSpeedWithBearingBefore(), competitorTrack.getBoatClass());
                this.addSpeedWithCourseRecord(maneuver.getSpeedWithBearingAfter(), competitorTrack.getBoatClass());
            }
        }
    }

    public void addSpeedWithCourseRecord(SpeedWithBearing speedWithCourse, BoatClass boatClass) {
        SpeedStatistics speedStatistics = this.getSpeedStatistics(boatClass, speedWithCourse.getBearing().getDegrees());
        speedStatistics.addSpeed(speedWithCourse.getKnots());
    }

    private SpeedStatistics getSpeedStatistics(BoatClass boatClass, double courseInDegrees) {
        SpeedStatistics speedStatistics;
        int index = (int)courseInDegrees / 10;
        SpeedStatistics[] speedStatisticsPerCourseCluster = this.speedsPerBoatClass.get(boatClass);
        if (speedStatisticsPerCourseCluster == null) {
            speedStatisticsPerCourseCluster = new SpeedStatistics[36];
            this.speedsPerBoatClass.put(boatClass, speedStatisticsPerCourseCluster);
        }
        if ((speedStatistics = speedStatisticsPerCourseCluster[index]) == null) {
            speedStatisticsPerCourseCluster[index] = speedStatistics = new SpeedStatistics();
        }
        return speedStatistics;
    }

    public SpeedWithBearingWithConfidence<Void> estimateWind() {
        ArrayList<SpeedWithBearingWithConfidence<Void>> windCandidates = new ArrayList<SpeedWithBearingWithConfidence<Void>>();
        int trueWindCourseCandidateInDegrees = 0;
        while (trueWindCourseCandidateInDegrees < 360) {
            int totalSpeeds = 0;
            int speedsWithinDeadWindZone = 0;
            ArrayList<Util.Pair<WindSpeedRange, Integer>> windSpeedRangesWithFixesCount = new ArrayList<Util.Pair<WindSpeedRange, Integer>>();
            int[] pointOfSailCounts = new int[CoarseGrainedPointOfSail.values().length];
            for (Map.Entry<BoatClass, SpeedStatistics[]> speedsForBoatClassEntry : this.speedsPerBoatClass.entrySet()) {
                BoatClass boatClass = speedsForBoatClassEntry.getKey();
                SpeedStatistics[] speedsForBoatClass = speedsForBoatClassEntry.getValue();
                DegreeBearingImpl trueWindCourseCandidate = new DegreeBearingImpl((double)trueWindCourseCandidateInDegrees);
                int i = 0;
                while (i < 36) {
                    SpeedStatistics speedStatistics = speedsForBoatClass[i];
                    if (speedStatistics != null && speedStatistics.getSpeedsCount() > 0 && speedStatistics.getAvgSpeed() > 2.0) {
                        DegreeBearingImpl boatCourse = new DegreeBearingImpl((double)(i * 10));
                        Bearing twa = trueWindCourseCandidate.reverse().getDifferenceTo((Bearing)boatCourse);
                        double absTwaInDegrees = Math.abs(twa.getDegrees());
                        double avgSpeedInKnots = speedStatistics.getAvgSpeed();
                        WindSpeedRange windSpeedRange = this.getWindSpeedRange(boatClass, avgSpeedInKnots, absTwaInDegrees);
                        if (windSpeedRange != null) {
                            FineGrainedPointOfSail pointOfSail = FineGrainedPointOfSail.valueOf(twa.getDegrees());
                            pointOfSailCounts[pointOfSail.getCoarseGrainedPointOfSail().ordinal()] = speedStatistics.getSpeedsCount();
                            windSpeedRangesWithFixesCount.add((Util.Pair<WindSpeedRange, Integer>)new Util.Pair((Object)windSpeedRange, (Object)speedStatistics.getSpeedsCount()));
                            totalSpeeds += speedStatistics.getSpeedsCount();
                            if (absTwaInDegrees <= 20.0) {
                                speedsWithinDeadWindZone += speedStatistics.getSpeedsCount();
                            }
                        }
                    }
                    ++i;
                }
            }
            SpeedWithConfidence<Void> windSpeedCandidate = this.calculateWindCandidate(windSpeedRangesWithFixesCount, totalSpeeds, speedsWithinDeadWindZone);
            if (windSpeedCandidate != null) {
                windCandidates.add((SpeedWithBearingWithConfidence<Void>)new SpeedWithBearingWithConfidenceImpl((SpeedWithBearing)new KnotSpeedWithBearingImpl(((Speed)windSpeedCandidate.getObject()).getKnots(), (Bearing)new DegreeBearingImpl((double)trueWindCourseCandidateInDegrees)), windSpeedCandidate.getConfidence(), null));
            }
            trueWindCourseCandidateInDegrees += 5;
        }
        SpeedWithBearingWithConfidence<Void> bestCandidate = this.determineBestWindCandidateAndCalculateConfidence(windCandidates);
        return bestCandidate;
    }

    private SpeedWithBearingWithConfidence<Void> determineBestWindCandidateAndCalculateConfidence(List<SpeedWithBearingWithConfidence<Void>> windCandidates) {
        SpeedWithBearingWithConfidence<Void> bestWindCandidate = null;
        for (SpeedWithBearingWithConfidence<Void> windCandidate : windCandidates) {
            if (bestWindCandidate != null && !(bestWindCandidate.getConfidence() < windCandidate.getConfidence())) continue;
            bestWindCandidate = windCandidate;
        }
        double bestChallengingConfidence = 0.0;
        for (SpeedWithBearingWithConfidence<Void> windCandidate : windCandidates) {
            double bearingToBestCandidate = windCandidate.getObject().getBearing().getDifferenceTo(bestWindCandidate.getObject().getBearing()).getDegrees();
            double absBearingToBestCandidate = Math.abs(bearingToBestCandidate);
            if (!(absBearingToBestCandidate >= 45.0) || !(bestChallengingConfidence < windCandidate.getConfidence())) continue;
            bestChallengingConfidence = windCandidate.getConfidence();
        }
        if (bestWindCandidate == null) {
            return null;
        }
        double bestVariance = 1.0 / bestWindCandidate.getConfidence();
        double bestChallengingVariance = 1.0 / bestChallengingConfidence;
        double realConfidence = (bestChallengingVariance - bestVariance) / (bestChallengingVariance + bestVariance);
        return new SpeedWithBearingWithConfidenceImpl(bestWindCandidate.getObject(), realConfidence, null);
    }

    private SpeedWithConfidence<Void> calculateWindCandidate(List<Util.Pair<WindSpeedRange, Integer>> windSpeedRangesWithFixesCount, int totalSpeeds, int speedsWithinDeadWindZone) {
        WindSpeedRange extendedWindSpeedRange = null;
        for (Util.Pair<WindSpeedRange, Integer> windSpeedRangeWithFixesCount : windSpeedRangesWithFixesCount) {
            WindSpeedRange windSpeedRange = extendedWindSpeedRange = extendedWindSpeedRange == null ? (WindSpeedRange)windSpeedRangeWithFixesCount.getA() : extendedWindSpeedRange.extend((WindSpeedRange)windSpeedRangeWithFixesCount.getA());
        }
        if (extendedWindSpeedRange == null) {
            return null;
        }
        double twsInKnots = 0.0;
        for (Util.Pair<WindSpeedRange, Integer> windSpeedRangeWithFixesCount : windSpeedRangesWithFixesCount) {
            double weight = 1.0 * (double)((Integer)windSpeedRangeWithFixesCount.getB()).intValue() / (double)totalSpeeds;
            twsInKnots += weight * ((WindSpeedRange)windSpeedRangeWithFixesCount.getA()).getMiddleSpeed();
        }
        double variance = 0.0;
        for (Util.Pair<WindSpeedRange, Integer> windSpeedRangeWithFixesCount : windSpeedRangesWithFixesCount) {
            double deviationOfSpeedFromRange = ((WindSpeedRange)windSpeedRangeWithFixesCount.getA()).getDeviationOfSpeedFromRange(twsInKnots);
            double relevanceFactor = 1.0 * (double)((Integer)windSpeedRangeWithFixesCount.getB()).intValue() / (double)totalSpeeds;
            variance += deviationOfSpeedFromRange * deviationOfSpeedFromRange * relevanceFactor;
        }
        return new SpeedWithConfidenceImpl((Speed)new KnotSpeedImpl(twsInKnots), 1.0 / (variance *= 1.0 - 1.0 * (double)speedsWithinDeadWindZone / (double)totalSpeeds), null);
    }

    public WindSpeedRange getWindSpeedRange(BoatClass boatClass, double avgSpeedInKnots, double absTwaInDegrees) {
        Util.Pair windSpeeds;
        try {
            windSpeeds = this.polarService.estimateWindSpeeds(boatClass, (Speed)new KnotSpeedImpl(avgSpeedInKnots), (Bearing)new DegreeBearingImpl(absTwaInDegrees));
        }
        catch (NotEnoughDataHasBeenAddedException e) {
            return null;
        }
        double minSpeed = 0.0;
        double maxSpeed = 0.0;
        for (Speed speed : (List)windSpeeds.getA()) {
            double speedInKnots = speed.getKnots();
            if (!(speedInKnots > 2.0)) continue;
            if (minSpeed == 0.0 || minSpeed > speedInKnots) {
                minSpeed = speedInKnots;
            }
            if (maxSpeed != 0.0 && !(maxSpeed < speedInKnots)) continue;
            maxSpeed = speedInKnots;
        }
        return minSpeed == 0.0 ? null : new WindSpeedRange(minSpeed, maxSpeed);
    }

    public WindWithConfidence<Void> estimateAverageWind() {
        SpeedWithBearingWithConfidence<Void> wind = this.estimateWind();
        WindWithConfidenceImpl windWithConfidence = null;
        if (wind != null) {
            windWithConfidence = new WindWithConfidenceImpl((Wind)new WindImpl(null, null, wind.getObject()), wind.getConfidence(), null, wind.getObject().getKnots() > 0.0);
        }
        return windWithConfidence;
    }

    public Speed getWindSpeed(ManeuverForEstimation maneuver, Bearing windCourse) {
        WindSpeedRange windSpeedRange = null;
        BoatClass boatClass = maneuver.getBoatClass();
        if (maneuver.isClean()) {
            double absTwaInDegrees = Math.abs(windCourse.reverse().getDifferenceTo(maneuver.getSpeedWithBearingBefore().getBearing()).getDegrees());
            double avgSpeedInKnots = maneuver.getSpeedWithBearingBefore().getKnots();
            windSpeedRange = this.getWindSpeedRange(boatClass, avgSpeedInKnots, absTwaInDegrees);
            absTwaInDegrees = Math.abs(windCourse.reverse().getDifferenceTo(maneuver.getSpeedWithBearingAfter().getBearing()).getDegrees());
            avgSpeedInKnots = maneuver.getSpeedWithBearingAfter().getKnots();
            WindSpeedRange currentTwaWindSpeedRange = this.getWindSpeedRange(boatClass, avgSpeedInKnots, absTwaInDegrees);
            if (currentTwaWindSpeedRange != null) {
                WindSpeedRange windSpeedRange2 = windSpeedRange = windSpeedRange == null ? currentTwaWindSpeedRange : windSpeedRange.extend(currentTwaWindSpeedRange);
            }
        }
        if (windSpeedRange != null) {
            return new KnotSpeedImpl(windSpeedRange.getMiddleSpeed());
        }
        return new KnotSpeedImpl(0.0);
    }
}

