/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.outlierremoval;

import com.sap.sailing.windestimation.aggregator.outlierremoval.AbstractOutlierRemovalWindEstimator;
import com.sap.sailing.windestimation.aggregator.outlierremoval.OutlierAnalysisResult;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.windinference.TwdFromManeuverCalculator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Util;
import java.util.List;

public class NeighborBasedOutlierRemovalWindEstimator
extends AbstractOutlierRemovalWindEstimator {
    public NeighborBasedOutlierRemovalWindEstimator(TwdFromManeuverCalculator twdCalculator) {
        super(twdCalculator);
    }

    @Override
    protected OutlierAnalysisResult analyzeOutlier(List<Util.Pair<Bearing, ManeuverWithEstimatedType>> twdsWithManeuvers) {
        Bearing lastNonOutlierTwd;
        OutlierAnalysisResult outlierAnalysisResult = new OutlierAnalysisResult();
        Bearing previousTwd = null;
        Bearing currentTwd = null;
        Bearing firstNonOutlierTwd = null;
        Bearing firstNearlyNonOutlierTwd = null;
        for (Util.Pair<Bearing, ManeuverWithEstimatedType> twdWithManeuver : twdsWithManeuvers) {
            Bearing nextTwd = (Bearing)twdWithManeuver.getA();
            if (currentTwd != null && Math.abs(currentTwd.getDifferenceTo(nextTwd).getDegrees()) <= 30.0) {
                if (firstNearlyNonOutlierTwd == null) {
                    firstNearlyNonOutlierTwd = currentTwd;
                }
                if (previousTwd != null && Math.abs(currentTwd.getDifferenceTo(previousTwd).getDegrees()) <= 30.0) {
                    firstNonOutlierTwd = currentTwd;
                    break;
                }
            }
            previousTwd = currentTwd;
            currentTwd = nextTwd;
        }
        Bearing bearing = lastNonOutlierTwd = firstNonOutlierTwd == null ? firstNearlyNonOutlierTwd : firstNonOutlierTwd;
        if (lastNonOutlierTwd == null) {
            return outlierAnalysisResult;
        }
        for (Util.Pair<Bearing, ManeuverWithEstimatedType> twdWithManeuver : twdsWithManeuvers) {
            currentTwd = (Bearing)twdWithManeuver.getA();
            ManeuverWithEstimatedType maneuver = (ManeuverWithEstimatedType)twdWithManeuver.getB();
            if (Math.abs(currentTwd.getDifferenceTo(lastNonOutlierTwd).getDegrees()) <= 30.0) {
                outlierAnalysisResult.addIncludedManeuver(maneuver);
                lastNonOutlierTwd = currentTwd;
                continue;
            }
            outlierAnalysisResult.addExcludedManeuver(maneuver);
        }
        return outlierAnalysisResult;
    }
}

