/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.outlierremoval;

import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.windestimation.aggregator.outlierremoval.AbstractOutlierRemovalWindEstimator;
import com.sap.sailing.windestimation.aggregator.outlierremoval.OutlierAnalysisResult;
import com.sap.sailing.windestimation.data.ManeuverWithEstimatedType;
import com.sap.sailing.windestimation.windinference.TwdFromManeuverCalculator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Util;
import com.sap.sse.common.scalablevalue.ScalableValue;
import java.util.List;

public class MeanBasedOutlierRemovalWindEstimator
extends AbstractOutlierRemovalWindEstimator {
    public MeanBasedOutlierRemovalWindEstimator(TwdFromManeuverCalculator twdCalculator) {
        super(twdCalculator);
    }

    @Override
    protected OutlierAnalysisResult analyzeOutlier(List<Util.Pair<Bearing, ManeuverWithEstimatedType>> twdsWithManeuvers) {
        ScalableBearing twdSum = null;
        double likelihoodSum = 0.0;
        OutlierAnalysisResult outlierAnalysisResult = new OutlierAnalysisResult();
        for (Util.Pair<Bearing, ManeuverWithEstimatedType> twdWithManeuvers : twdsWithManeuvers) {
            Bearing twd = (Bearing)twdWithManeuvers.getA();
            double confidence = ((ManeuverWithEstimatedType)twdWithManeuvers.getB()).getConfidence();
            ScalableBearing scalableTwd = new ScalableBearing(twd).multiply(confidence);
            likelihoodSum += confidence;
            ScalableBearing scalableBearing = twdSum = twdSum == null ? scalableTwd : twdSum.add((ScalableValue)scalableTwd);
        }
        if (twdSum != null) {
            Bearing avgTwd = twdSum.divide(likelihoodSum);
            for (Util.Pair<Bearing, ManeuverWithEstimatedType> twdWithManeuver : twdsWithManeuvers) {
                Bearing twd = (Bearing)twdWithManeuver.getA();
                ManeuverWithEstimatedType maneuver = (ManeuverWithEstimatedType)twdWithManeuver.getB();
                if (Math.abs(avgTwd.getDifferenceTo(twd).getDegrees()) <= 30.0) {
                    outlierAnalysisResult.addIncludedManeuver(maneuver);
                    continue;
                }
                outlierAnalysisResult.addExcludedManeuver(maneuver);
            }
        }
        return outlierAnalysisResult;
    }
}

