/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.msthmm;

import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractMstGraphGenerator<T> {
    private final List<NodeWithNeighbors<T>> nodes;
    private static final int MAX_DEPTH_FOR_DFS = 100;

    public AbstractMstGraphGenerator() {
        this(new ArrayList<NodeWithNeighbors<T>>());
    }

    protected AbstractMstGraphGenerator(List<NodeWithNeighbors<T>> nodes) {
        this.nodes = nodes;
    }

    public synchronized void addNode(T observation) {
        NodeWithNeighbors<T> newNode = new NodeWithNeighbors<T>(observation);
        LinkedList<NodeWithDistance<T>> distancesFromOtherNodes = this.getDistancesFromNearestOtherNodes(observation);
        this.nodes.add(newNode);
        if (!distancesFromOtherNodes.isEmpty()) {
            Collections.sort(distancesFromOtherNodes);
            NodeWithDistance<T> closestNeighborWithDistance = distancesFromOtherNodes.get(0);
            this.addEdge(newNode, closestNeighborWithDistance);
            ListIterator<NodeWithDistance<T>> iterator = distancesFromOtherNodes.listIterator(1);
            while (iterator.hasNext()) {
                NodeWithDistance<T> otherCloseNeighbor = iterator.next();
                Util.Triple<Double, NodeWithNeighbors<T>, NodeWithNeighbors<T>> canReachAndEdgeWithHighestDistance = this.canReach(otherCloseNeighbor.getNodeWithNeighbors(), newNode);
                if (canReachAndEdgeWithHighestDistance == null || !((Double)canReachAndEdgeWithHighestDistance.getA() > otherCloseNeighbor.getDistance())) continue;
                this.removeEdge((NodeWithNeighbors)canReachAndEdgeWithHighestDistance.getB(), (NodeWithNeighbors)canReachAndEdgeWithHighestDistance.getC());
                this.addEdge(newNode, otherCloseNeighbor);
            }
        }
    }

    private LinkedList<NodeWithDistance<T>> getDistancesFromNearestOtherNodes(T observation) {
        LinkedList<NodeWithDistance<T>> result = new LinkedList<NodeWithDistance<T>>();
        for (NodeWithNeighbors<T> node : this.nodes) {
            double distance = this.getDistanceBetweenObservations(observation, node.getObservation());
            NodeWithDistance<T> neighborWithDistance = new NodeWithDistance<T>(node, distance);
            result.add(neighborWithDistance);
        }
        return result;
    }

    protected abstract double getDistanceBetweenObservations(T var1, T var2);

    private void addEdge(NodeWithNeighbors<T> newNode, NodeWithDistance<T> closestNeighborWithDistance) {
        newNode.addNeighbor(closestNeighborWithDistance);
        closestNeighborWithDistance.getNodeWithNeighbors().addNeighbor(newNode, closestNeighborWithDistance.getDistance());
    }

    private void removeEdge(NodeWithNeighbors<T> a, NodeWithNeighbors<T> b) {
        a.removeNeighbor(b);
        b.removeNeighbor(a);
    }

    private Util.Triple<Double, NodeWithNeighbors<T>, NodeWithNeighbors<T>> canReach(NodeWithNeighbors<T> nodeToReach, NodeWithNeighbors<T> nodeToStartFrom) {
        return this.canReach(nodeToReach, nodeToStartFrom, null, 0, new Util.Triple((Object)0.0, nodeToReach, nodeToStartFrom));
    }

    private Util.Triple<Double, NodeWithNeighbors<T>, NodeWithNeighbors<T>> canReach(NodeWithNeighbors<T> nodeToReach, NodeWithNeighbors<T> nodeToStartFrom, NodeWithNeighbors<T> firstNodeOfPathToIgnore, int currentDepth, Util.Triple<Double, NodeWithNeighbors<T>, NodeWithNeighbors<T>> edgeWithHighestDistance) {
        if (nodeToStartFrom == nodeToReach) {
            return edgeWithHighestDistance;
        }
        if (currentDepth < 100) {
            int nextDepth = currentDepth + 1;
            for (NodeWithDistance<T> neighborWithDistance : nodeToStartFrom.getNeighbors()) {
                double distance;
                Util.Triple newEdgeWithHighestDistance;
                Util.Triple<Double, NodeWithNeighbors<T>, NodeWithNeighbors<T>> canReachAndEdgeWithHighestDistance;
                NodeWithNeighbors<T> node = neighborWithDistance.getNodeWithNeighbors();
                if (node == firstNodeOfPathToIgnore || (canReachAndEdgeWithHighestDistance = this.canReach(nodeToReach, node, nodeToStartFrom, nextDepth, newEdgeWithHighestDistance = (distance = neighborWithDistance.getDistance()) > (Double)edgeWithHighestDistance.getA() ? new Util.Triple((Object)distance, nodeToStartFrom, node) : edgeWithHighestDistance)) == null) continue;
                return canReachAndEdgeWithHighestDistance;
            }
        }
        return null;
    }

    public List<NodeWithNeighbors<T>> getNodes() {
        return this.nodes;
    }

    public List<NodeWithNeighbors<T>> getClonedNodes() {
        ArrayList<NodeWithNeighbors<T>> clonedNodes = new ArrayList<NodeWithNeighbors<T>>(this.nodes.size());
        HashMap<NodeWithNeighbors<T>, NodeWithNeighbors<T>> existingToNewNodesMapping = new HashMap<NodeWithNeighbors<T>, NodeWithNeighbors<T>>();
        for (NodeWithNeighbors<T> node : this.nodes) {
            NodeWithNeighbors<T> clonedNode = (NodeWithNeighbors<T>)existingToNewNodesMapping.get(node);
            if (clonedNode == null) {
                clonedNode = new NodeWithNeighbors<T>(node.getObservation());
                existingToNewNodesMapping.put(node, clonedNode);
            }
            for (NodeWithDistance<T> neighborNodeWithDistance : node.getNeighbors()) {
                NodeWithNeighbors<T> neighborNode = neighborNodeWithDistance.getNodeWithNeighbors();
                NodeWithNeighbors<T> clonedNeighborNode = (NodeWithNeighbors<T>)existingToNewNodesMapping.get(neighborNode);
                if (clonedNeighborNode == null) {
                    clonedNeighborNode = new NodeWithNeighbors<T>(neighborNode.getObservation());
                    existingToNewNodesMapping.put(neighborNode, clonedNeighborNode);
                }
                NodeWithDistance<T> clonedNeighborNodeWithDistance = new NodeWithDistance<T>(clonedNeighborNode, neighborNodeWithDistance.getDistance());
                clonedNode.addNeighbor(clonedNeighborNodeWithDistance);
            }
            clonedNodes.add(clonedNode);
        }
        return clonedNodes;
    }

    protected static class NodeWithDistance<T>
    implements Comparable<NodeWithDistance<T>> {
        private final NodeWithNeighbors<T> neighbor;
        private final double distance;

        public NodeWithDistance(NodeWithNeighbors<T> neighbor, double distance) {
            this.neighbor = neighbor;
            this.distance = distance;
        }

        public NodeWithNeighbors<T> getNodeWithNeighbors() {
            return this.neighbor;
        }

        public double getDistance() {
            return this.distance;
        }

        @Override
        public int compareTo(NodeWithDistance<T> o) {
            return Double.compare(this.distance, o.getDistance());
        }

        public int hashCode() {
            return this.neighbor.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || this.neighbor == obj;
        }

        public String toString() {
            return "NodeWithDistance [neighbor=" + this.neighbor + ", distance=" + this.distance + "]";
        }
    }

    protected static class NodeWithNeighbors<T> {
        private final List<NodeWithDistance<T>> neighbors = new ArrayList<NodeWithDistance<T>>(2);
        private final T observation;

        public NodeWithNeighbors(T observation) {
            this.observation = observation;
        }

        public void addNeighbor(NodeWithNeighbors<T> nodeWithNeighbors, double distance) {
            NodeWithDistance<T> neighborWithDistance = new NodeWithDistance<T>(nodeWithNeighbors, distance);
            this.addNeighbor(neighborWithDistance);
        }

        public void addNeighbor(NodeWithDistance<T> neighborWithDistance) {
            this.neighbors.add(neighborWithDistance);
        }

        public void removeNeighbor(NodeWithNeighbors<T> nodeWithNeighbors) {
            this.neighbors.remove(nodeWithNeighbors);
        }

        public List<NodeWithDistance<T>> getNeighbors() {
            return this.neighbors;
        }

        public T getObservation() {
            return this.observation;
        }

        public String toString() {
            return "NodeWithNeighbors [observation=" + this.observation + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.observation == null ? 0 : this.observation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof NodeWithDistance && ((NodeWithDistance)obj).neighbor == this;
        }
    }
}

