/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sailing.domain.tracking.impl.WindComparator;
import com.sap.sailing.domain.tracking.impl.WindTrackImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.util.impl.AbstractUnmodifiableNavigableSet;
import com.sap.sse.shared.util.impl.DescendingNavigableSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;

public abstract class VirtualWindFixesAsNavigableSet
extends AbstractUnmodifiableNavigableSet<Wind> {
    private static final long serialVersionUID = -7191543758261688727L;
    private final long resolutionInMilliseconds;
    private final TrackedRace trackedRace;
    private final TimePoint from;
    private final TimePoint to;
    private final WindTrack track;

    protected VirtualWindFixesAsNavigableSet(WindTrack track, TrackedRace trackedRace, long resolutionInMilliseconds) {
        this(track, trackedRace, null, null, resolutionInMilliseconds);
    }

    protected abstract Wind getWind(Position var1, TimePoint var2);

    protected VirtualWindFixesAsNavigableSet(WindTrack track, TrackedRace trackedRace, TimePoint from, TimePoint to, long resolutionInMilliseconds) {
        this.track = track;
        this.trackedRace = trackedRace;
        assert (from == null || from.asMillis() % resolutionInMilliseconds == 0L);
        this.from = from;
        assert (to == null || to.asMillis() % resolutionInMilliseconds == 0L);
        this.to = to;
        this.resolutionInMilliseconds = resolutionInMilliseconds;
    }

    public long getResolutionInMilliseconds() {
        return this.resolutionInMilliseconds;
    }

    protected WindTrack getTrack() {
        return this.track;
    }

    protected TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    protected TimePoint lowerToResolution(TimePoint timePoint) {
        TimePoint result;
        TimePoint timePointOfLastEvent = this.getTrackedRace().getTimePointOfNewestEvent();
        if (timePointOfLastEvent != null && timePoint.compareTo((Object)timePointOfLastEvent) > 0) {
            result = this.lowerToResolution(timePointOfLastEvent);
        } else {
            long minuend = timePoint.asMillis() <= 0L ? this.getResolutionInMilliseconds() + 1L : 1L;
            result = new MillisecondsTimePoint((timePoint.asMillis() - minuend) / this.getResolutionInMilliseconds() * this.getResolutionInMilliseconds());
        }
        return result;
    }

    protected TimePoint floorToResolution(TimePoint timePoint) {
        TimePoint result;
        TimePoint timePointOfLastEvent = this.getTrackedRace().getTimePointOfNewestEvent();
        if (timePointOfLastEvent != null && timePoint.compareTo((Object)timePointOfLastEvent) > 0) {
            result = this.floorToResolution(timePointOfLastEvent);
        } else {
            long minuend = timePoint.asMillis() < 0L ? this.getResolutionInMilliseconds() : 0L;
            result = new MillisecondsTimePoint((timePoint.asMillis() - minuend) / this.getResolutionInMilliseconds() * this.getResolutionInMilliseconds());
        }
        return result;
    }

    protected TimePoint ceilingToResolution(TimePoint timePoint) {
        TimePoint result;
        TimePoint startOfTracking = this.getTrackedRace().getStartOfTracking();
        if (startOfTracking != null && timePoint.compareTo((Object)startOfTracking) < 0) {
            result = this.ceilingToResolution(startOfTracking);
        } else {
            long minuend = timePoint.asMillis() <= 0L ? this.getResolutionInMilliseconds() + 1L : 1L;
            result = new MillisecondsTimePoint(((timePoint.asMillis() - minuend) / this.getResolutionInMilliseconds() + 1L) * this.getResolutionInMilliseconds());
        }
        return result;
    }

    protected TimePoint higherToResolution(TimePoint timePoint) {
        TimePoint result;
        TimePoint startOfTracking = this.getTrackedRace().getStartOfTracking();
        if (startOfTracking != null && timePoint.compareTo((Object)startOfTracking) < 0) {
            result = this.higherToResolution(startOfTracking);
        } else {
            long minuend = timePoint.asMillis() < 0L ? this.getResolutionInMilliseconds() - 1L : 0L;
            result = new MillisecondsTimePoint(((timePoint.asMillis() - minuend) / this.getResolutionInMilliseconds() + 1L) * this.getResolutionInMilliseconds());
        }
        return result;
    }

    protected TimePoint getFrom() {
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        return this.from == null ? (startOfRace == null ? new MillisecondsTimePoint(Long.MAX_VALUE) : this.floorToResolution(startOfRace.minus(TrackedRaceImpl.TIME_BEFORE_START_TO_TRACK_WIND_MILLIS))) : this.from;
    }

    protected TimePoint getTo() {
        return this.getToInternal() == null ? (this.getTrackedRace().getTimePointOfNewestEvent() == null ? new MillisecondsTimePoint(1L) : this.ceilingToResolution(this.getTrackedRace().getTimePointOfNewestEvent())) : this.getToInternal();
    }

    public Wind lower(Wind w) {
        TimePoint timePoint = this.lowerToResolution(w.getTimePoint());
        return timePoint.compareTo((Object)this.getFrom()) < 0 ? null : this.getWind(w.getPosition(), timePoint);
    }

    public Wind floor(Wind w) {
        TimePoint timePoint = this.floorToResolution(w.getTimePoint());
        return timePoint.compareTo((Object)this.getFrom()) < 0 ? null : this.getWind(w.getPosition(), timePoint);
    }

    public Wind ceiling(Wind w) {
        TimePoint timePoint = this.ceilingToResolution(w.getTimePoint());
        return timePoint.compareTo((Object)this.getTo()) > 0 ? null : this.getWind(w.getPosition(), timePoint);
    }

    public Wind higher(Wind w) {
        TimePoint timePoint = this.higherToResolution(w.getTimePoint());
        return timePoint.compareTo((Object)this.getTo()) > 0 ? null : this.getWind(w.getPosition(), timePoint);
    }

    public Iterator<Wind> iterator() {
        return new Iterator<Wind>(){
            private TimePoint timePoint;
            {
                this.timePoint = VirtualWindFixesAsNavigableSet.this.getFrom();
            }

            @Override
            public boolean hasNext() {
                return this.timePoint.compareTo((Object)VirtualWindFixesAsNavigableSet.this.getTo()) <= 0;
            }

            @Override
            public Wind next() {
                Wind result = VirtualWindFixesAsNavigableSet.this.floor(VirtualWindFixesAsNavigableSet.this.createDummyWindFix(this.timePoint));
                this.timePoint = new MillisecondsTimePoint(this.timePoint.asMillis() + VirtualWindFixesAsNavigableSet.this.getResolutionInMilliseconds());
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public NavigableSet<Wind> descendingSet() {
        return new DescendingNavigableSet((NavigableSet)((Object)this));
    }

    public Iterator<Wind> descendingIterator() {
        return new Iterator<Wind>(){
            private TimePoint timePoint;
            {
                this.timePoint = VirtualWindFixesAsNavigableSet.this.lowerToResolution(VirtualWindFixesAsNavigableSet.this.getTo());
            }

            @Override
            public boolean hasNext() {
                return this.timePoint.compareTo((Object)VirtualWindFixesAsNavigableSet.this.getFrom()) >= 0;
            }

            @Override
            public Wind next() {
                Wind result = VirtualWindFixesAsNavigableSet.this.floor(new WindTrackImpl.DummyWind(this.timePoint));
                this.timePoint = new MillisecondsTimePoint(this.timePoint.asMillis() - VirtualWindFixesAsNavigableSet.this.getResolutionInMilliseconds());
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public NavigableSet<Wind> subSet(Wind fromElement, boolean fromInclusive, Wind toElement, boolean toInclusive) {
        return this.createSubset(this.getTrack(), this.getTrackedRace(), fromInclusive ? this.ceilingToResolution(fromElement.getTimePoint()) : this.higherToResolution(fromElement.getTimePoint()), toInclusive ? this.floorToResolution(toElement.getTimePoint()) : this.lowerToResolution(toElement.getTimePoint()));
    }

    protected abstract NavigableSet<Wind> createSubset(WindTrack var1, TrackedRace var2, TimePoint var3, TimePoint var4);

    public NavigableSet<Wind> headSet(Wind toElement, boolean inclusive) {
        return this.createSubset(this.getTrack(), this.getTrackedRace(), null, inclusive ? this.ceilingToResolution(toElement.getTimePoint()) : this.lowerToResolution(toElement.getTimePoint()));
    }

    public NavigableSet<Wind> tailSet(Wind fromElement, boolean inclusive) {
        return this.createSubset(this.getTrack(), this.getTrackedRace(), inclusive ? this.floorToResolution(fromElement.getTimePoint()) : this.higherToResolution(fromElement.getTimePoint()), null);
    }

    public SortedSet<Wind> subSet(Wind fromElement, Wind toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    public SortedSet<Wind> headSet(Wind toElement) {
        return this.headSet(toElement, false);
    }

    public SortedSet<Wind> tailSet(Wind fromElement) {
        return this.tailSet(fromElement, true);
    }

    public Comparator<? super Wind> comparator() {
        return WindComparator.INSTANCE;
    }

    public Wind first() {
        return this.floor(new WindTrackImpl.DummyWind(this.getFrom()));
    }

    public Wind last() {
        return this.ceiling(new WindTrackImpl.DummyWind(this.getTo()));
    }

    public int size() {
        return (int)((this.getTo().asMillis() - this.getFrom().asMillis()) / this.getResolutionInMilliseconds());
    }

    public boolean contains(Object o) {
        boolean result = false;
        if (o instanceof Wind) {
            Wind wind = (Wind)o;
            result = wind.getTimePoint().asMillis() % this.getResolutionInMilliseconds() == 0L && wind.getTimePoint().compareTo((Object)this.getFrom()) >= 0 && wind.getTimePoint().compareTo((Object)this.getTo()) < 0;
        }
        return result;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        Iterator<Wind> iterator = this.iterator();
        while (iterator.hasNext()) {
            Wind w = iterator.next();
            result[i++] = w;
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        Object[] result = a;
        if (result.length < this.size()) {
            result = new Object[this.size()];
        }
        int i = 0;
        Iterator<Wind> iterator = this.iterator();
        while (iterator.hasNext()) {
            Wind w = iterator.next();
            result[i++] = w;
        }
        Object[] tResult = result;
        return tResult;
    }

    protected TimePoint getToInternal() {
        return this.to;
    }

    protected WindTrackImpl.DummyWind createDummyWindFix(TimePoint timePoint) {
        return new WindTrackImpl.DummyWind(timePoint);
    }
}

