/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.meta;

import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.meta.AbstractMetaLeaderboard;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FlexibleMetaLeaderboard
extends AbstractMetaLeaderboard {
    private static final long serialVersionUID = 789076326144062944L;
    private final List<Leaderboard> leaderboards = new ArrayList<Leaderboard>();
    private final NamedReentrantReadWriteLock leaderboardsLock = new NamedReentrantReadWriteLock("leaderboards collection of " + FlexibleMetaLeaderboard.class.getSimpleName() + " " + this.getName(), false);

    public FlexibleMetaLeaderboard(String name, ScoringScheme scoringScheme, ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        super(name, scoringScheme, resultDiscardingRule);
    }

    @Override
    public Iterable<Leaderboard> getLeaderboards() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            ArrayList<Leaderboard> arrayList = new ArrayList<Leaderboard>(this.leaderboards);
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    public void addLeaderboard(Leaderboard leaderboard) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            this.leaderboards.add(leaderboard);
            this.registerScoreCorrectionAndRaceColumnChangeForwarder(leaderboard);
            this.getRaceColumnListeners().notifyListenersAboutRaceColumnAddedToContainer(this.getColumnForLeaderboard(leaderboard));
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    public void removeLeaderboard(Leaderboard leaderboard) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        try {
            this.leaderboards.remove(leaderboard);
            this.getRaceColumnListeners().notifyListenersAboutRaceColumnRemovedFromContainer(this.getColumnForLeaderboard(leaderboard));
            this.unregisterScoreCorrectionChangeForwarder(leaderboard);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsLock);
        }
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        return Collections.emptySet();
    }

    @Override
    public LeaderboardType getLeaderboardType() {
        return LeaderboardType.FlexibleMetaLeaderboard;
    }
}

