/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DelegateLeaderboard
implements Serializable {
    private static final long serialVersionUID = -1764036951368356044L;
    private RegattaLeaderboard delegateLeaderboard;
    private final transient Supplier<RegattaLeaderboard> delegateLeaderboardSupplier;
    private final ConcurrentHashMap<Consumer<RegattaLeaderboard>, Boolean> triggerWhenDelegateLeaderboardIsResolved;

    public DelegateLeaderboard(Supplier<RegattaLeaderboard> delegateLeaderboardSupplier) {
        this.delegateLeaderboardSupplier = delegateLeaderboardSupplier;
        this.triggerWhenDelegateLeaderboardIsResolved = new ConcurrentHashMap();
    }

    public RegattaLeaderboard getDelegateLeaderboard() {
        if (this.delegateLeaderboard == null) {
            if (this.delegateLeaderboardSupplier == null) {
                throw new NullPointerException("Internal error: Regatta leaderboard supplier is null; this can only happen upon premature serialization");
            }
            this.delegateLeaderboard = this.delegateLeaderboardSupplier.get();
            if (this.delegateLeaderboard != null) {
                Iterator i = ((ConcurrentHashMap.KeySetView)this.triggerWhenDelegateLeaderboardIsResolved.keySet()).iterator();
                while (i.hasNext()) {
                    Consumer toTrigger = (Consumer)i.next();
                    toTrigger.accept(this.delegateLeaderboard);
                    i.remove();
                }
            }
        }
        return this.delegateLeaderboard;
    }

    public void scheduleLeaderboardConsumer(Consumer<RegattaLeaderboard> consumer) {
        this.triggerWhenDelegateLeaderboardIsResolved.put(consumer, true);
    }

    public void runOrSchedule(Consumer<RegattaLeaderboard> action) {
        if (this.getDelegateLeaderboard() != null) {
            action.accept(this.getDelegateLeaderboard());
        } else {
            this.scheduleLeaderboardConsumer(action);
        }
    }
}

