/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogRegisteredCompetitorsAndBoatsAnalyzer;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RaceLogUsesOwnCompetitorsAnalyzer;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.util.impl.RaceColumnListeners;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.Map;

public abstract class SimpleAbstractRaceColumn
implements RaceColumn {
    private static final long serialVersionUID = -3590156714385187908L;
    private final RaceColumnListeners raceColumnListeners = new RaceColumnListeners();
    private Double explicitFactor;

    @Override
    public Util.Pair<Competitor, RaceColumn> getKey(Competitor competitor) {
        return new Util.Pair((Object)competitor, (Object)this);
    }

    @Override
    public RaceColumnListeners getRaceColumnListeners() {
        return this.raceColumnListeners;
    }

    @Override
    public void addRaceColumnListener(RaceColumnListener listener) {
        this.getRaceColumnListeners().addRaceColumnListener(listener);
    }

    @Override
    public void removeRaceColumnListener(RaceColumnListener listener) {
        this.getRaceColumnListeners().removeRaceColumnListener(listener);
    }

    @Override
    public RaceDefinition getRaceDefinition(Fleet fleet) {
        TrackedRace trackedRace = this.getTrackedRace(fleet);
        RaceDefinition result = null;
        if (trackedRace != null) {
            result = trackedRace.getRace();
        }
        return result;
    }

    @Override
    public void setFactor(Double factor) {
        Double oldExplicitFactor = this.getExplicitFactor();
        this.explicitFactor = factor;
        this.raceColumnListeners.notifyListenersAboutFactorChanged(this, oldExplicitFactor, factor);
    }

    @Override
    public Double getExplicitFactor() {
        return this.explicitFactor;
    }

    @Override
    public boolean isStartsWithZeroScore() {
        return false;
    }

    @Override
    public boolean isDiscardable() {
        return !this.isMedalRace();
    }

    @Override
    public boolean isCarryForward() {
        return false;
    }

    @Override
    public boolean isTotalOrderDefinedByFleet() {
        return !this.hasSplitFleetContiguousScoring();
    }

    @Override
    public boolean hasSplitFleetContiguousScoring() {
        return false;
    }

    @Override
    public boolean hasCrossFleetMergedRanking() {
        return false;
    }

    @Override
    public boolean hasSplitFleets() {
        return Util.size(this.getFleets()) > 1;
    }

    @Override
    public Map<Competitor, Boat> getCompetitorsRegisteredInRacelog(Fleet fleet) {
        RaceLog raceLog = this.getRaceLog(fleet);
        if (raceLog == null) {
            return Collections.emptyMap();
        }
        RaceLogRegisteredCompetitorsAndBoatsAnalyzer analyzer = new RaceLogRegisteredCompetitorsAndBoatsAnalyzer(raceLog);
        return (Map)analyzer.analyze();
    }

    @Override
    public boolean isCompetitorRegistrationInRacelogEnabled(Fleet fleet) {
        RaceLog raceLog = this.getRaceLog(fleet);
        if (raceLog == null) {
            return false;
        }
        RaceLogUsesOwnCompetitorsAnalyzer analyzer = new RaceLogUsesOwnCompetitorsAnalyzer(raceLog);
        return (Boolean)analyzer.analyze();
    }
}

