/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.impl.RaceColumnInSeriesImpl;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.util.impl.RaceColumnListeners;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.RenamableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeriesImpl
extends RenamableImpl
implements Series,
RaceColumnListener {
    private static final long serialVersionUID = -1640404303144907381L;
    private final Map<String, Fleet> fleetsByName;
    private final List<Fleet> fleetsInAscendingOrder;
    private final List<RaceColumnInSeries> raceColumns;
    private boolean isMedal;
    private boolean isFleetsCanRunInParallel;
    private Regatta regatta;
    private final RaceColumnListeners raceColumnListeners;
    private ThresholdBasedResultDiscardingRule resultDiscardingRule;
    private boolean oneAlwaysStaysOne;
    private Integer maximumNumberOfDiscards;
    private boolean startsWithZeroScore;
    private boolean firstColumnIsNonDiscardableCarryForward;
    private boolean hasSplitFleetContiguousScoring;
    private boolean hasCrossFleetMergedRanking;

    public SeriesImpl(String name, boolean isMedal, boolean isFleetsCanRunInParallel, Iterable<? extends Fleet> fleets, Iterable<String> raceColumnNames, TrackedRegattaRegistry trackedRegattaRegistry) {
        super(name);
        if (fleets == null || Util.isEmpty(fleets)) {
            throw new IllegalArgumentException("Series must have at least one fleet");
        }
        this.fleetsByName = new HashMap<String, Fleet>();
        for (Fleet fleet : fleets) {
            this.fleetsByName.put(fleet.getName(), fleet);
        }
        this.fleetsInAscendingOrder = new ArrayList<Fleet>();
        Util.addAll(fleets, this.fleetsInAscendingOrder);
        Collections.sort(this.fleetsInAscendingOrder);
        this.raceColumns = new ArrayList<RaceColumnInSeries>();
        this.isMedal = isMedal;
        this.isFleetsCanRunInParallel = isFleetsCanRunInParallel;
        this.raceColumnListeners = new RaceColumnListeners();
        for (String string : raceColumnNames) {
            this.addRaceColumn(string, trackedRegattaRegistry);
        }
    }

    @Override
    public void addRaceColumnListener(RaceColumnListener listener) {
        this.raceColumnListeners.addRaceColumnListener(listener);
    }

    @Override
    public void removeRaceColumnListener(RaceColumnListener listener) {
        this.raceColumnListeners.removeRaceColumnListener(listener);
    }

    @Override
    public Regatta getRegatta() {
        return this.regatta;
    }

    @Override
    public void setRegatta(Regatta regatta) {
        if (this.regatta != null) {
            this.detachRaceExecutionOrderProviderFromTrackedRacesInRaceColumns();
        }
        this.regatta = regatta;
        if (this.regatta != null) {
            this.attachRaceExecutionOrderProviderToTrackedRacesInRaceColumns();
        } else {
            this.detachRaceExecutionOrderProviderFromTrackedRacesInRaceColumns();
        }
    }

    public Iterable<? extends Fleet> getFleets() {
        return this.fleetsInAscendingOrder;
    }

    @Override
    public Fleet getFleetByName(String fleetName) {
        return this.fleetsByName.get(fleetName);
    }

    @Override
    public Iterable<? extends RaceColumnInSeries> getRaceColumns() {
        return new ArrayList<RaceColumnInSeries>(this.raceColumns);
    }

    @Override
    public RaceColumnInSeries addRaceColumn(String raceColumnName, TrackedRegattaRegistry trackedRegattaRegistry) {
        return this.addRaceColumn(this.raceColumns.size(), raceColumnName, trackedRegattaRegistry);
    }

    @Override
    public RaceColumnInSeries addRaceColumn(int insertIndex, String raceColumnName, TrackedRegattaRegistry trackedRegattaRegistry) {
        RaceColumnInSeriesImpl result = this.createRaceColumn(raceColumnName, trackedRegattaRegistry);
        if (this.raceColumnListeners.canAddRaceColumnToContainer(result)) {
            result.addRaceColumnListener(this);
            this.raceColumns.add(insertIndex, result);
            this.raceColumnListeners.notifyListenersAboutRaceColumnAddedToContainer(result);
        } else {
            result = null;
        }
        return result;
    }

    private RaceColumnInSeriesImpl createRaceColumn(String raceColumnName, TrackedRegattaRegistry trackedRegattaRegistry) {
        return new RaceColumnInSeriesImpl(raceColumnName, this, trackedRegattaRegistry);
    }

    private void attachRaceExecutionOrderProviderToTrackedRacesInRaceColumns() {
        for (RaceColumnInSeries raceColumnInSeries : this.raceColumns) {
            for (Fleet fleet : raceColumnInSeries.getFleets()) {
                TrackedRace trackedRace = raceColumnInSeries.getTrackedRace(fleet);
                if (trackedRace == null || this.regatta == null) continue;
                trackedRace.attachRaceExecutionProvider(this.regatta.getRaceExecutionOrderProvider());
            }
        }
    }

    private void detachRaceExecutionOrderProviderFromTrackedRacesInRaceColumns() {
        for (RaceColumnInSeries raceColumnInSeries : this.raceColumns) {
            for (Fleet fleet : raceColumnInSeries.getFleets()) {
                TrackedRace trackedRace = raceColumnInSeries.getTrackedRace(fleet);
                if (trackedRace == null || this.regatta == null || this.regatta.getRaceExecutionOrderProvider() == null) continue;
                trackedRace.detachRaceExecutionOrderProvider(this.regatta.getRaceExecutionOrderProvider());
            }
        }
    }

    @Override
    public void removeRaceColumn(String raceColumnName) {
        RaceColumnInSeries rc = this.getRaceColumnByName(raceColumnName);
        if (rc != null) {
            this.raceColumns.remove(rc);
            this.raceColumnListeners.notifyListenersAboutRaceColumnRemovedFromContainer(rc);
            rc.removeRaceColumnListener(this);
        }
    }

    @Override
    public RaceColumnInSeries getRaceColumnByName(String columnName) {
        for (RaceColumnInSeries raceColumnInSeries : this.getRaceColumns()) {
            if (!raceColumnInSeries.getName().equals(columnName)) continue;
            return raceColumnInSeries;
        }
        return null;
    }

    public boolean isMedal() {
        return this.isMedal;
    }

    @Override
    public void setIsMedal(boolean isMedal) {
        boolean oldIsMedal = this.isMedal;
        this.isMedal = isMedal;
        if (oldIsMedal != isMedal) {
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                this.raceColumnListeners.notifyListenersAboutIsMedalRaceChanged(raceColumn, isMedal);
            }
        }
    }

    public boolean isFleetsCanRunInParallel() {
        return this.isFleetsCanRunInParallel;
    }

    @Override
    public void setIsFleetsCanRunInParallel(boolean isFleetsCanRunInParallel) {
        boolean oldIsFleetsCanRunInParallel = this.isFleetsCanRunInParallel;
        this.isFleetsCanRunInParallel = isFleetsCanRunInParallel;
        if (oldIsFleetsCanRunInParallel != isFleetsCanRunInParallel) {
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                this.raceColumnListeners.notifyListenersAboutIsFleetsCanRunInParallelChanged(raceColumn, isFleetsCanRunInParallel);
            }
        }
    }

    @Override
    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.raceColumnListeners.notifyListenersAboutTrackedRaceLinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.raceColumnListeners.notifyListenersAboutTrackedRaceUnlinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void isMedalRaceChanged(RaceColumn raceColumn, boolean newIsMedalRace) {
        this.raceColumnListeners.notifyListenersAboutIsMedalRaceChanged(raceColumn, newIsMedalRace);
    }

    @Override
    public void isFleetsCanRunInParallelChanged(RaceColumn raceColumn, boolean newIsFleetsCanRunInParallel) {
        this.raceColumnListeners.notifyListenersAboutIsFleetsCanRunInParallelChanged(raceColumn, newIsFleetsCanRunInParallel);
    }

    @Override
    public void isStartsWithZeroScoreChanged(RaceColumn raceColumn, boolean newIsStartsWithZeroScore) {
        this.raceColumnListeners.notifyListenersAboutIsStartsWithZeroScoreChanged(raceColumn, newIsStartsWithZeroScore);
    }

    @Override
    public void hasSplitFleetContiguousScoringChanged(RaceColumn raceColumn, boolean hasSplitFleetContiguousScoring) {
        this.raceColumnListeners.notifyListenersAboutHasSplitFleetContiguousScoringChanged(raceColumn, hasSplitFleetContiguousScoring);
    }

    @Override
    public void hasCrossFleetMergedRankingChanged(RaceColumn raceColumn, boolean hasCrossFleetMergedRanking) {
        this.raceColumnListeners.notifyListenersAboutHasCrossFleetMergedRankingChanged(raceColumn, hasCrossFleetMergedRanking);
    }

    @Override
    public void isFirstColumnIsNonDiscardableCarryForwardChanged(RaceColumn raceColumn, boolean firstColumnIsNonDiscardableCarryForward) {
        this.raceColumnListeners.notifyListenersAboutIsFirstColumnIsNonDiscardableCarryForwardChanged(raceColumn, firstColumnIsNonDiscardableCarryForward);
    }

    @Override
    public void raceColumnAddedToContainer(RaceColumn raceColumn) {
        this.raceColumnListeners.notifyListenersAboutRaceColumnAddedToContainer(raceColumn);
    }

    @Override
    public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
        this.raceColumnListeners.notifyListenersAboutRaceColumnRemovedFromContainer(raceColumn);
    }

    @Override
    public void raceColumnMoved(RaceColumn raceColumn, int newIndex) {
        this.raceColumnListeners.notifyListenersAboutRaceColumnMoved(raceColumn, newIndex);
    }

    @Override
    public void raceColumnNameChanged(RaceColumn raceColumn, String oldName, String newName) {
        this.raceColumnListeners.notifyListenersAboutRaceColumnNameChanged(raceColumn, oldName, newName);
    }

    @Override
    public void factorChanged(RaceColumn raceColumn, Double oldFactor, Double newFactor) {
        this.raceColumnListeners.notifyListenersAboutFactorChanged(raceColumn, oldFactor, newFactor);
    }

    @Override
    public void oneAlwaysStaysOneChanged(RaceColumn raceColumn, boolean oneAlwaysStaysOne) {
        this.raceColumnListeners.notifyListenersAboutOneAlwaysStaysOneChanged(raceColumn, oneAlwaysStaysOne);
    }

    @Override
    public void competitorDisplayNameChanged(Competitor competitor, String oldDisplayName, String displayName) {
        this.raceColumnListeners.notifyListenersAboutCompetitorDisplayNameChanged(competitor, oldDisplayName, displayName);
    }

    @Override
    public void resultDiscardingRuleChanged(ResultDiscardingRule oldDiscardingRule, ResultDiscardingRule newDiscardingRule) {
        this.raceColumnListeners.notifyListenersAboutResultDiscardingRuleChanged(oldDiscardingRule, newDiscardingRule);
    }

    @Override
    public void maximumNumberOfDiscardsChanged(Integer oldMaximumNumberOfDiscards, Integer newMaximumNumberOfDiscards) {
        this.raceColumnListeners.notifyListenersAboutMaximumNumberOfDiscardsChanged(oldMaximumNumberOfDiscards, newMaximumNumberOfDiscards);
    }

    @Override
    public void raceLogEventAdded(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        this.raceColumnListeners.notifyListenersAboutRaceLogEventAdded(raceColumn, raceLogIdentifier, event);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public ThresholdBasedResultDiscardingRule getResultDiscardingRule() {
        return this.resultDiscardingRule;
    }

    @Override
    public void setResultDiscardingRule(ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        ThresholdBasedResultDiscardingRule oldResultDiscardingRule = this.resultDiscardingRule;
        if (!Util.equalsWithNull((Object)oldResultDiscardingRule, (Object)resultDiscardingRule)) {
            this.resultDiscardingRule = resultDiscardingRule;
            this.raceColumnListeners.notifyListenersAboutResultDiscardingRuleChanged(oldResultDiscardingRule, resultDiscardingRule);
        }
        this.resultDiscardingRule = resultDiscardingRule;
    }

    @Override
    public Integer getMaximumNumberOfDiscards() {
        return this.maximumNumberOfDiscards;
    }

    @Override
    public void setMaximumNumberOfDiscards(Integer maximumNumberOfDiscards) {
        Integer oldMaximumNumberOfDiscards = this.getMaximumNumberOfDiscards();
        if (!Util.equalsWithNull((Object)oldMaximumNumberOfDiscards, (Object)maximumNumberOfDiscards)) {
            this.maximumNumberOfDiscards = maximumNumberOfDiscards;
            this.raceColumnListeners.notifyListenersAboutMaximumNumberOfDiscardsChanged(oldMaximumNumberOfDiscards, maximumNumberOfDiscards);
        }
    }

    @Override
    public boolean definesSeriesDiscardThresholds() {
        return this.getResultDiscardingRule() != null;
    }

    @Override
    public boolean isStartsWithZeroScore() {
        return this.startsWithZeroScore;
    }

    private RaceColumn getFirstRaceColumn() {
        RaceColumn result = null;
        if (!this.raceColumns.isEmpty()) {
            result = this.raceColumns.get(0);
        }
        return result;
    }

    @Override
    public void setStartsWithZeroScore(boolean startsWithZeroScore) {
        boolean oldStartsWithZeroScore = this.startsWithZeroScore;
        if (oldStartsWithZeroScore != startsWithZeroScore) {
            this.startsWithZeroScore = startsWithZeroScore;
            RaceColumn firstRaceColumnInSeries = this.getFirstRaceColumn();
            if (firstRaceColumnInSeries != null) {
                this.raceColumnListeners.notifyListenersAboutIsStartsWithZeroScoreChanged(firstRaceColumnInSeries, startsWithZeroScore);
            }
        }
    }

    @Override
    public void setSplitFleetContiguousScoring(boolean hasSplitFleetContiguousScoring) {
        if (hasSplitFleetContiguousScoring != this.hasSplitFleetContiguousScoring) {
            this.hasSplitFleetContiguousScoring = hasSplitFleetContiguousScoring;
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                this.raceColumnListeners.notifyListenersAboutHasSplitFleetContiguousScoringChanged(raceColumn, hasSplitFleetContiguousScoring);
            }
        }
    }

    @Override
    public void setCrossFleetMergedRanking(boolean hasCrossFleetMergedRanking) {
        if (hasCrossFleetMergedRanking != this.hasCrossFleetMergedRanking) {
            this.hasCrossFleetMergedRanking = hasCrossFleetMergedRanking;
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                this.raceColumnListeners.notifyListenersAboutHasCrossFleetMergedRankingChanged(raceColumn, hasCrossFleetMergedRanking);
            }
        }
    }

    @Override
    public boolean isFirstColumnNonDiscardableCarryForward() {
        return this.firstColumnIsNonDiscardableCarryForward;
    }

    @Override
    public void setFirstColumnIsNonDiscardableCarryForward(boolean firstColumnIsNonDiscardableCarryForward) {
        boolean oldFirstColumnIsNonDiscardableCarryForward = this.firstColumnIsNonDiscardableCarryForward;
        if (oldFirstColumnIsNonDiscardableCarryForward != firstColumnIsNonDiscardableCarryForward) {
            this.firstColumnIsNonDiscardableCarryForward = firstColumnIsNonDiscardableCarryForward;
            RaceColumn firstRaceColumnInSeries = this.getFirstRaceColumn();
            if (firstRaceColumnInSeries != null) {
                this.raceColumnListeners.notifyListenersAboutIsFirstColumnIsNonDiscardableCarryForwardChanged(firstRaceColumnInSeries, firstColumnIsNonDiscardableCarryForward);
            }
        }
        this.firstColumnIsNonDiscardableCarryForward = firstColumnIsNonDiscardableCarryForward;
    }

    @Override
    public boolean hasSplitFleetContiguousScoring() {
        return this.hasSplitFleetContiguousScoring;
    }

    @Override
    public boolean hasCrossFleetMergedRanking() {
        return this.hasCrossFleetMergedRanking;
    }

    @Override
    public boolean isOneAlwaysStaysOne() {
        return this.oneAlwaysStaysOne;
    }

    @Override
    public void setOneAlwaysStaysOne(boolean oneAlwaysStaysOne) {
        boolean oldOneAlwaysStaysOne = this.oneAlwaysStaysOne;
        if (oldOneAlwaysStaysOne != oneAlwaysStaysOne) {
            this.oneAlwaysStaysOne = oneAlwaysStaysOne;
            for (RaceColumn raceColumn : this.getRaceColumns()) {
                this.raceColumnListeners.notifyListenersAboutOneAlwaysStaysOneChanged(raceColumn, oneAlwaysStaysOne);
            }
        }
    }
}

