/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sse.common.Named;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import com.sap.sse.security.ui.client.i18n.StringMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class AccessControlledButtonPanel
extends Composite {
    private final HorizontalPanel panel = new HorizontalPanel();
    private final Map<Button, Supplier<Boolean>> buttonToPermissions = new HashMap();
    private final Supplier<Boolean> createPermissionCheck;
    private final Supplier<Boolean> createPermissionCheckWithoutServerCreateObjectCheck;
    private final Supplier<Boolean> removePermissionCheck;
    private final Supplier<Boolean> updatePermissionCheck;
    private final BiConsumer<Button, Supplier<Boolean>> visibilityUpdater = (btn, check) -> btn.setVisible(((Boolean)check.get()).booleanValue());

    public AccessControlledButtonPanel(UserService userService, HasPermissions type) {
        this.createPermissionCheck = () -> userService.hasCurrentUserPermissionToCreateObjectOfType(type);
        this.createPermissionCheckWithoutServerCreateObjectCheck = () -> userService.hasCurrentUserPermissionToCreateObjectOfTypeWithoutServerCreateObjectPermissionCheck(type);
        this.removePermissionCheck = () -> userService.hasCurrentUserPermissionToDeleteAnyObjectOfType(type);
        this.updatePermissionCheck = () -> userService.hasCurrentUserPermissionToUpdateAnyObjectOfType(type);
        userService.addUserStatusEventHandler((user, preAuth) -> this.updateVisibility(), true);
        this.initWidget((Widget)this.panel);
    }

    public Button addUnsecuredAction(String text, Command callback) {
        return this.addAction(text, () -> true, callback);
    }

    public TextBox addUnsecuredTextBox(String label) {
        TextBox textBox = new TextBox();
        textBox.getElement().setAttribute("placeholder", label);
        textBox.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        this.panel.add((Widget)textBox);
        return textBox;
    }

    public Button addCreateAction(String text, Command callback) {
        return this.addAction(text, this.createPermissionCheck, callback);
    }

    public Button addCreateActionWithoutServerCreateObjectPermissionCheck(String text, Command callback) {
        return this.addAction(text, this.createPermissionCheckWithoutServerCreateObjectCheck, callback);
    }

    public Button addRemoveAction(String text, Command callback) {
        return this.addAction(text, this.removePermissionCheck, callback);
    }

    public <T extends Named> Button addRemoveAction(String text, SetSelectionModel<T> selectionModel, boolean withConfirmation, Command callback) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("Selection model for a remove action must not be null");
        }
        ClickHandler handler = this.wrap(this.removePermissionCheck, callback);
        SelectedElementsCountingButton button = withConfirmation ? new SelectedElementsCountingButton(text, selectionModel, arg_0 -> ((StringMessages)StringMessages.INSTANCE).doYouReallyWantToRemoveSelectedElements(arg_0), handler) : new SelectedElementsCountingButton(text, selectionModel, handler);
        return this.resolveButtonVisibility(this.removePermissionCheck, (Button)button);
    }

    public Button addUpdateAction(String text, Command callback) {
        return this.addAction(text, this.updatePermissionCheck, callback);
    }

    public Button addAction(String text, Supplier<Boolean> permissionCheck, Command callback) {
        return this.resolveButtonVisibility(permissionCheck, new Button(text, this.wrap(permissionCheck, callback)));
    }

    public <T extends Named> Button addCountingAction(String text, SetSelectionModel<T> selectionModel, Supplier<Boolean> permissionCheck, Command callback) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("Selection model for a remove action must not be null");
        }
        SelectedElementsCountingButton button = new SelectedElementsCountingButton(text, selectionModel, this.wrap(permissionCheck, callback));
        return this.resolveButtonVisibility(permissionCheck, (Button)button);
    }

    private Button resolveButtonVisibility(Supplier<Boolean> permissionCheck, Button button) {
        this.buttonToPermissions.put(button, permissionCheck);
        button.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        this.panel.add((Widget)button);
        this.visibilityUpdater.accept(button, permissionCheck);
        return button;
    }

    private ClickHandler wrap(Supplier<Boolean> permissionCheck, Command callback) {
        return event -> {
            if (((Boolean)permissionCheck.get()).booleanValue()) {
                callback.execute();
            }
        };
    }

    public void updateVisibility() {
        this.buttonToPermissions.forEach(this.visibilityUpdater);
    }

    public void insertWidgetAtPosition(Widget widget, int index) {
        this.panel.insert(widget, index);
    }

    public void addUnsecuredWidget(Widget widget) {
        widget.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
        this.panel.add(widget);
    }
}

