/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.rabbitmq.client.Channel;
import com.sap.sse.ServerInfo;
import com.sap.sse.gateway.AbstractHttpServlet;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicablesProvider;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.ReplicationServletActions;
import com.sap.sse.replication.ReplicationStatus;
import com.sap.sse.replication.impl.Activator;
import com.sap.sse.replication.impl.OSGiReplicableTracker;
import com.sap.sse.replication.impl.RabbitOutputStream;
import com.sap.sse.replication.interfaces.impl.ReplicaDescriptorImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.util.HttpRequestUtils;
import com.sap.sse.util.impl.CountingOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.json.simple.JSONObject;
import org.osgi.util.tracker.ServiceTracker;

public class ReplicationServlet
extends AbstractHttpServlet {
    private static final Logger logger = Logger.getLogger(ReplicationServlet.class.getName());
    private static final long serialVersionUID = 4835516998934433846L;
    private static final int INITIAL_LOAD_PACKAGE_SIZE = 0x100000;
    private final ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker;
    private final ReplicablesProvider replicablesProvider;

    public ReplicationServlet() throws Exception {
        this(new OSGiReplicableTracker(Activator.getDefaultContext()), (ServiceTracker<ReplicationService, ReplicationService>)new ServiceTracker(Activator.getDefaultContext(), ReplicationService.class.getName(), null));
    }

    public ReplicationServlet(ReplicablesProvider replicablesProvider, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker) {
        this.replicablesProvider = replicablesProvider;
        this.replicationServiceTracker = replicationServiceTracker;
        if (replicationServiceTracker != null) {
            replicationServiceTracker.open();
        }
    }

    protected ReplicationService getReplicationService() {
        return this.replicationServiceTracker == null ? null : (ReplicationService)this.replicationServiceTracker.getService();
    }

    private void handleAction(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            String action = req.getParameter("action");
            logger.info("Received replication-related request, action is " + action + ", subject is " + (SecurityUtils.getSubject() == null ? null : SecurityUtils.getSubject().getPrincipal()));
            switch (ReplicationServletActions.Action.valueOf((String)action)) {
                case REGISTER: {
                    logger.info("Received replica registration request");
                    this.checkReplicatorPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.REPLICATE);
                    this.registerClientWithReplicationService(req, resp);
                    break;
                }
                case DEREGISTER: {
                    logger.info("Received replica deregistration request");
                    this.checkReplicatorPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.REPLICATE);
                    this.deregisterClientWithReplicationService(req, resp);
                    break;
                }
                case INITIAL_LOAD: {
                    logger.info("Received replication initial load request");
                    this.checkReplicatorPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.REPLICATE);
                    String[] replicableIdsAsStrings = req.getParameter("replicaIdsAsStringsCommaSeparated").split(",");
                    Channel channel = this.getReplicationService().createMasterChannel();
                    try {
                        RabbitOutputStream ros = new RabbitOutputStream(0x100000, channel, "initialLoad-for-" + HttpRequestUtils.getClientIP((HttpServletRequest)req) + "@" + new Date() + "-" + UUID.randomUUID(), false);
                        PrintWriter br = new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream()));
                        resp.setContentType("text/plain");
                        br.println(ros.getQueueName());
                        br.flush();
                        CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)ros, 0x100000L, Level.INFO, "uncompressed output for initial load for " + HttpRequestUtils.getClientIP((HttpServletRequest)req));
                        LZ4BlockOutputStream compressingOutputStream = new LZ4BlockOutputStream((OutputStream)countingOutputStream);
                        String[] stringArray = replicableIdsAsStrings;
                        int n = replicableIdsAsStrings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String replicableIdAsString = stringArray[n2];
                            logger.info("Serializing initial load for replicable " + replicableIdAsString + " for remote host " + HttpRequestUtils.getClientIP((HttpServletRequest)req));
                            Replicable replicable = this.replicablesProvider.getReplicable(replicableIdAsString, false);
                            if (replicable == null) {
                                String msg = "Couldn't find replicable with ID " + replicableIdAsString + ". Aborting serialization of initial load.";
                                logger.severe(msg);
                                resp.sendError(500, StringEscapeUtils.escapeHtml((String)msg));
                                break;
                            }
                            try {
                                replicable.serializeForInitialReplication((OutputStream)compressingOutputStream);
                                logger.info("Done serializing initial load for replicable " + replicableIdAsString + " for remote host " + HttpRequestUtils.getClientIP((HttpServletRequest)req));
                            }
                            catch (Throwable e) {
                                logger.info("Error trying to serialize initial load for replication: " + e.getMessage());
                                logger.log(Level.SEVERE, "doGet", e);
                                resp.setStatus(500);
                                resp.getWriter().append("Error obtaining status; see server logs for details.");
                            }
                            ++n2;
                        }
                        logger.info("Done serializing initial loads for remote host " + HttpRequestUtils.getClientIP((HttpServletRequest)req));
                        compressingOutputStream.finish();
                        countingOutputStream.close();
                        break;
                    }
                    finally {
                        channel.getConnection().close();
                    }
                }
                case STATUS: {
                    try {
                        this.reportStatus(req, resp);
                    }
                    catch (IllegalAccessException e) {
                        logger.info("Error obtaining replication status: " + e.getMessage());
                        logger.log(Level.SEVERE, "doGet", e);
                        resp.setStatus(500);
                        resp.getWriter().append("Error obtaining status; see server logs for details.");
                    }
                    break;
                }
                case STOP_REPLICATING: {
                    this.checkReplicatorPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.REPLICATE);
                    logger.info("Stopping replication from master upon " + (SecurityUtils.getSubject() == null ? null : SecurityUtils.getSubject().getPrincipal()) + "'s request.");
                    this.getReplicationService().stopToReplicateFromMaster();
                    resp.setContentType("text/plain");
                    resp.setStatus(200);
                    break;
                }
                default: {
                    resp.sendError(400, "Action " + StringEscapeUtils.escapeHtml((String)action) + " not understood. Must be one of " + Arrays.toString(ReplicationServletActions.Action.values()));
                    break;
                }
            }
        }
        catch (AuthorizationException e) {
            resp.sendError(401, "The user is not authenticated or not permitted to manage replication. See server log for details.");
        }
    }

    private void checkReplicatorPermission(HasPermissions.Action action) {
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier(action, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
    }

    private void reportStatus(HttpServletRequest req, HttpServletResponse resp) throws IllegalAccessException, IOException {
        ReplicationStatus status = this.getReplicationService().getStatus();
        JSONObject result = status.toJSONObject();
        resp.setContentType("application/json;charset=UTF-8");
        result.writeJSONString((Writer)resp.getWriter());
        if (status.isAvailable()) {
            resp.setStatus(200);
        } else {
            resp.setStatus(503);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getParameter("action") != null) {
            try {
                this.handleAction(req, resp);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occurred while trying to receive and apply operation initiated on replica", e);
                resp.sendError(500, "Exception " + e + " occurred while trying to receive and apply operation initiated on replica. Re-trying can make sense.");
            }
        } else {
            ServletInputStream is = req.getInputStream();
            DataInputStream dis = new DataInputStream((InputStream)is);
            String replicableIdAsString = dis.readUTF();
            Replicable replicable = this.replicablesProvider.getReplicable(replicableIdAsString, false);
            if (replicable != null) {
                logger.fine("Received request to apply and replicate an operation from a replica for replicable " + replicable);
                this.checkReplicatorPermission((HasPermissions.Action)SecuredSecurityTypes.ServerActions.REPLICATE);
                try {
                    this.applyOperationToReplicable(replicable, (InputStream)is);
                }
                catch (InvocationTargetException ite) {
                    Throwable originalException = ite.getTargetException();
                    if (originalException instanceof RuntimeException && originalException.getCause() != null) {
                        originalException = originalException.getCause();
                    }
                    logger.log(Level.SEVERE, "Unrecoverable error applying operation received from replica", originalException);
                    resp.sendError(400, "Exception " + ite.getCause() + " occurred while trying to receive and apply operation initiated on replica. Please do not re-send.");
                }
                catch (ClassNotFoundException cnfe) {
                    logger.log(Level.SEVERE, "Exception occurred while trying to de-serialize operation", cnfe);
                    resp.sendError(400, "Exception " + cnfe + " occurred while trying to de-serialize operation initiated on replica. Please do not re-send");
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Exception occurred while trying to receive and apply operation initiated on replica", ioe);
                    resp.sendError(500, "Exception " + ioe + " occurred while trying to receive and apply operation initiated on replica. Re-trying can make sense.");
                }
            } else {
                logger.warning("Received operation for replicable " + replicableIdAsString + ", but a replicable with that ID couldn't be found. Ignoring the operation.");
            }
        }
    }

    private <S, R, O extends OperationWithResult<S, ?>> void applyOperationToReplicable(Replicable<S, O> replicable, InputStream is) throws ClassNotFoundException, IOException, InvocationTargetException {
        OperationWithResult operation;
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(replicable.getClass().getClassLoader());
        try {
            operation = replicable.readOperation(is, new HashMap());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error trying to de-serialize an operation for replicable " + replicable.getId(), e);
            throw e;
        }
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        logger.fine("Applying operation of type " + operation.getClassForLogging().getName() + (operation.getOriginServerName() == null ? "" : " originating from server \"" + operation.getOriginServerName() + "\"") + " received from replica to replicable " + replicable.toString());
        try {
            replicable.apply(operation);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void deregisterClientWithReplicationService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UUID replicaUuid = UUID.fromString(req.getParameter("uuid"));
        ReplicaDescriptor replica = this.getReplicationService().unregisterReplica(replicaUuid);
        if (replica != null) {
            logger.info("Deregistered replication client with this server " + replica.getIpAddress());
            resp.setContentType("text/plain");
            resp.getWriter().print(replica.getUuid());
        } else {
            logger.warning("Couldn't find replica to de-register with ID " + replicaUuid);
        }
    }

    private void registerClientWithReplicationService(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ReplicaDescriptor replica = this.getReplicaDescriptor(req);
        this.getReplicationService().registerReplica(replica);
        logger.info("Registered new replica " + replica);
        resp.setContentType("text/plain");
        resp.getWriter().print(replica.getUuid());
    }

    private ReplicaDescriptor getReplicaDescriptor(HttpServletRequest req) throws UnknownHostException {
        String forwardedFor = req.getHeader("X-Forwarded-For");
        InetAddress ipAddress = forwardedFor != null && !forwardedFor.trim().isEmpty() ? InetAddress.getByName(forwardedFor.split(",")[0].trim()) : InetAddress.getByName(req.getRemoteAddr());
        UUID uuid = UUID.fromString(req.getParameter("uuid"));
        String additional = req.getParameter("additional");
        String[] replicableIdsAsStrings = req.getParameter("replicaIdsAsStringsCommaSeparated").split(",");
        Integer port = req.getParameter("port") == null ? null : Integer.valueOf(req.getParameter("port"));
        return new ReplicaDescriptorImpl(ipAddress, port, uuid, additional, replicableIdsAsStrings);
    }
}

