/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.simulator.Grid;
import com.sap.sailing.simulator.TimedPosition;
import com.sap.sailing.simulator.windfield.WindControlParameters;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sailing.simulator.windfield.impl.WindFieldGeneratorImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.logging.Logger;

public class WindFieldGeneratorOscillationImpl
extends WindFieldGeneratorImpl
implements WindFieldGenerator {
    private static final long serialVersionUID = -7005970781594631010L;
    private Speed[] speed;
    private double timeScale = 0.0;
    private static Logger logger = Logger.getLogger(WindFieldGeneratorOscillationImpl.class.getName());

    public WindFieldGeneratorOscillationImpl(Grid boundary, WindControlParameters windParameters) {
        super(boundary, windParameters);
    }

    @Override
    public void generate(TimePoint start, TimePoint end, Duration step) {
        super.generate(start, end, step);
        if (this.positions == null || this.positions.length < 1) {
            return;
        }
        int vPoints = this.boundary.getResY();
        Distance vStep = this.boundary.getHeight().scale(1.0 / (double)(vPoints - 1));
        this.timeScale = this.windParameters.baseWindSpeed > 0.0 ? vStep.getNauticalMiles() / this.windParameters.baseWindSpeed : 0.0;
        this.initializeSpeed();
    }

    private void initializeSpeed() {
        if (this.positions == null || this.positions.length < 1) {
            return;
        }
        int ncol = this.boundary.getResX();
        this.speed = new Speed[ncol];
        double leftSpeed = this.windParameters.baseWindSpeed * this.windParameters.leftWindSpeed / 100.0;
        double middleSpeed = this.windParameters.baseWindSpeed * this.windParameters.middleWindSpeed / 100.0;
        double rightSpeed = this.windParameters.baseWindSpeed * this.windParameters.rightWindSpeed / 100.0;
        double midPoint = ((double)ncol - 1.0) / 2.0;
        int i = 0;
        while (i < ncol / 2) {
            this.speed[i] = new KnotSpeedImpl(leftSpeed + (double)i * (middleSpeed - leftSpeed) / midPoint);
            ++i;
        }
        if (ncol % 2 == 1) {
            this.speed[ncol / 2] = new KnotSpeedImpl(middleSpeed);
        }
        i = 0;
        while (i < ncol / 2) {
            this.speed[ncol - 1 - i] = new KnotSpeedImpl(rightSpeed + (double)i * (middleSpeed - rightSpeed) / midPoint);
            ++i;
        }
    }

    private Speed getSpeed(TimedPosition timedPosition) {
        Position p = timedPosition.getPosition();
        Util.Pair<Integer, Integer> positionIndex = this.getPositionIndex(p);
        if (positionIndex != null) {
            int colIndex = (Integer)positionIndex.getB();
            if (colIndex < 0) {
                colIndex = 0;
            }
            if (colIndex >= this.boundary.getResX()) {
                colIndex = this.boundary.getResX() - 1;
            }
            return this.speed[colIndex];
        }
        logger.severe("Error finding position " + p);
        return null;
    }

    private Bearing getBearing(TimedPosition timedPosition) {
        Position p = timedPosition.getPosition();
        Util.Pair<Integer, Integer> positionIndex = this.getPositionIndex(p);
        if (positionIndex != null) {
            int rowIndex = (Integer)positionIndex.getA();
            TimePoint timePoint = timedPosition.getTimePoint();
            int timeIndex = this.getTimeIndex(timePoint);
            DegreeBearingImpl phi0 = new DegreeBearingImpl(this.windParameters.baseWindBearing.doubleValue());
            double vStep = 1.0 / (double)(this.positions.length - 1);
            double t = (double)((long)timeIndex * this.timeStep.asMillis()) / 3600000.0 + (double)rowIndex * vStep * this.timeScale;
            double oAngle = Math.sin(Math.PI * 2 * t * this.windParameters.frequency) * this.windParameters.amplitude;
            DegreeBearingImpl angle = new DegreeBearingImpl(oAngle);
            angle = angle.add((Bearing)phi0);
            return angle;
        }
        logger.severe("Error finding position " + p);
        return null;
    }

    @Override
    public Wind getWind(TimedPosition timedPosition) {
        Speed speed = this.getSpeed(timedPosition);
        KnotSpeedWithBearingImpl wspeed = new KnotSpeedWithBearingImpl(speed.getKnots(), this.getBearing(timedPosition));
        return new WindImpl(timedPosition.getPosition(), timedPosition.getTimePoint(), (SpeedWithBearing)wspeed);
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(double timeScale) {
        this.timeScale = timeScale;
    }
}

