/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl;

import com.sap.sailing.aiagent.impl.AIAgentImpl;
import com.sap.sailing.aiagent.impl.RaceListener;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Util;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RaceColumnListener
implements RaceColumnListenerWithDefaultAction {
    private static final long serialVersionUID = -366609838503904875L;
    private final ConcurrentMap<Util.Pair<RaceColumn, Fleet>, RaceListener> raceListeners;
    private final AIAgentImpl aiAgent;
    private final Leaderboard leaderboard;

    public RaceColumnListener(Leaderboard leaderboard, AIAgentImpl aiAgent) {
        this.aiAgent = aiAgent;
        this.raceListeners = new ConcurrentHashMap<Util.Pair<RaceColumn, Fleet>, RaceListener>();
        this.leaderboard = leaderboard;
        leaderboard.addRaceColumnListener((com.sap.sailing.domain.base.RaceColumnListener)this);
        leaderboard.getRaceColumns().forEach(raceColumn -> raceColumn.getFleets().forEach(fleet -> Optional.ofNullable(raceColumn.getTrackedRace(fleet)).ifPresent(trackedRace -> this.addNewRaceListenerToTrackedRace(leaderboard, aiAgent, (RaceColumn)raceColumn, (Fleet)fleet, (TrackedRace)trackedRace))));
    }

    public boolean isTransient() {
        return true;
    }

    private void addNewRaceListenerToTrackedRace(Leaderboard leaderboard, AIAgentImpl aiAgent, RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        RaceListener raceListener = new RaceListener(aiAgent, leaderboard, raceColumn, fleet, trackedRace);
        trackedRace.addListener((RaceChangeListener)raceListener);
        this.raceListeners.put((Util.Pair<RaceColumn, Fleet>)new Util.Pair((Object)raceColumn, (Object)fleet), raceListener);
    }

    public void removeListener() {
        this.leaderboard.removeRaceColumnListener((com.sap.sailing.domain.base.RaceColumnListener)this);
        this.leaderboard.getRaceColumns().forEach(raceColumn -> raceColumn.getFleets().forEach(fleet -> Optional.ofNullable(raceColumn.getTrackedRace(fleet)).ifPresent(trackedRace -> this.removeRaceListenerFromTrackedRace((RaceColumn)raceColumn, (Fleet)fleet, (TrackedRace)trackedRace))));
    }

    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.addNewRaceListenerToTrackedRace(this.leaderboard, this.aiAgent, raceColumn, fleet, trackedRace);
    }

    public void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.removeRaceListenerFromTrackedRace(raceColumn, fleet, trackedRace);
    }

    private void removeRaceListenerFromTrackedRace(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        RaceListener raceListener = (RaceListener)this.raceListeners.remove(new Util.Pair((Object)raceColumn, (Object)fleet));
        if (raceListener != null) {
            trackedRace.removeListener((RaceChangeListener)raceListener);
        }
    }

    public void raceColumnAddedToContainer(RaceColumn raceColumn) {
        raceColumn.getFleets().forEach(fleet -> Optional.ofNullable(raceColumn.getTrackedRace(fleet)).ifPresent(trackedRace -> this.addNewRaceListenerToTrackedRace(this.leaderboard, this.aiAgent, raceColumn, (Fleet)fleet, (TrackedRace)trackedRace)));
    }

    public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
        raceColumn.getFleets().forEach(fleet -> Optional.ofNullable(raceColumn.getTrackedRace(fleet)).ifPresent(trackedRace -> this.removeRaceListenerFromTrackedRace(raceColumn, (Fleet)fleet, (TrackedRace)trackedRace)));
    }

    public void defaultAction() {
    }
}

