/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

@Immutable
public enum CommandOption {
    sp1co_selfetch_off(1),
    RESERVED_DO_NOT_USE_WAS_SCROLL_INSENSITIVE(2),
    sp1co_no_resultset_close_needed(4),
    HOLD_CURSORS_OVER_COMMIT(8),
    EXECUTE_LOCALLY(16),
    SCROLL_INSENSITIVE(32),
    HOLD_CURSORS_OVER_ROLLBACK(64);

    private static final CommandOption[] VALUES;
    private final int _value;

    public static Set<CommandOption> decode(int value) {
        EnumSet<CommandOption> commandOptions = EnumSet.noneOf(CommandOption.class);
        for (CommandOption commandOption : VALUES) {
            if ((value & commandOption.getValue()) == 0) continue;
            commandOptions.add(commandOption);
        }
        return commandOptions;
    }

    public static String getDisplayString(int value) {
        Set<CommandOption> commandOptions = CommandOption.decode(value);
        return value + (commandOptions.isEmpty() ? "(none)" : Arrays.toString(commandOptions.toArray()));
    }

    private CommandOption(int value) {
        if (Integer.numberOfTrailingZeros(value) != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    static {
        VALUES = CommandOption.values();
    }
}

