/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;

public abstract class AbstractGPSFixImpl
implements GPSFix {
    private static final long serialVersionUID = 9037068515469957639L;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        result = 31 * result + (this.getTimePoint() == null ? 0 : this.getTimePoint().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GPSFix)) {
            return false;
        }
        GPSFix other = (GPSFix)obj;
        if (this.getPosition() == null ? other.getPosition() != null : !this.getPosition().equals(other.getPosition())) {
            return false;
        }
        return !(this.getTimePoint() == null ? other.getTimePoint() != null : !this.getTimePoint().equals(other.getTimePoint()));
    }

    @Override
    public SpeedWithBearing getSpeedAndBearingRequiredToReach(GPSFix to) {
        Distance distance = this.getPosition().getDistance(to.getPosition());
        Bearing bearing = this.getPosition().getBearingGreatCircle(to.getPosition());
        Speed speed = distance.inTime(to.getTimePoint().asMillis() - this.getTimePoint().asMillis());
        return new KnotSpeedWithBearingImpl(speed.getKnots(), bearing);
    }

    @Override
    public boolean isValidityCached() {
        return false;
    }

    @Override
    public boolean isValidCached() {
        return false;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void cacheValidity(boolean isValid) {
    }

    @Override
    public boolean isEstimatedSpeedCached() {
        return false;
    }

    @Override
    public SpeedWithBearing getCachedEstimatedSpeed() {
        return null;
    }

    @Override
    public void invalidateEstimatedSpeedCache() {
    }

    @Override
    public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
    }
}

