/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.scalablevalue.impl;

import com.sap.sailing.domain.common.DoublePair;
import com.sap.sailing.domain.common.impl.RadianBearingImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;

public class ScalableBearing
implements ScalableValueWithDistance<DoublePair, Bearing> {
    private final double sin;
    private final double cos;

    public ScalableBearing(Bearing bearing) {
        this.sin = Math.sin(bearing.getRadians());
        this.cos = Math.cos(bearing.getRadians());
    }

    private ScalableBearing(double sin, double cos) {
        this.sin = sin;
        this.cos = cos;
    }

    public ScalableBearing multiply(double factor) {
        DoublePair pair = this.getValue();
        return new ScalableBearing(factor * pair.getA(), factor * pair.getB());
    }

    public ScalableBearing add(ScalableValue<DoublePair, Bearing> t) {
        DoublePair value = this.getValue();
        DoublePair tValue = (DoublePair)t.getValue();
        return new ScalableBearing(value.getA() + tValue.getA(), value.getB() + tValue.getB());
    }

    public Bearing divide(double divisor) {
        RadianBearingImpl result;
        if (this.sin == 0.0 && this.cos == 0.0) {
            result = null;
        } else {
            double angle = this.cos == 0.0 ? (this.sin >= 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan2(this.sin, this.cos);
            result = new RadianBearingImpl(angle < 0.0 ? angle + Math.PI * 2 : angle);
        }
        return result;
    }

    public DoublePair getValue() {
        return new DoublePair(this.sin, this.cos);
    }

    public double getDistance(Bearing other) {
        return Math.abs(this.divide(1.0).getDifferenceTo(other).getDegrees());
    }

    public double getApproximateDegreeDistanceTo(Bearing a) {
        double scale = Math.sqrt(this.sin * this.sin + this.cos * this.cos);
        double x = this.cos / scale;
        double y = this.sin / scale;
        double ax = Math.cos(a.getRadians());
        double ay = Math.sin(a.getRadians());
        double normalDistance = Math.sqrt((x - ax) * (x - ax) + (y - ay) * (y - ay));
        return normalDistance / Math.PI * 180.0;
    }
}

