/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.impl.WindSpeedSteppingImpl;

public class WindSpeedSteppingWithMaxDistance
extends WindSpeedSteppingImpl {
    private static final long serialVersionUID = -2207840179212727591L;
    private double maxDistance;

    WindSpeedSteppingWithMaxDistance() {
    }

    public WindSpeedSteppingWithMaxDistance(double[] levels, double maxDistance) {
        super(levels);
        this.maxDistance = maxDistance;
    }

    @Override
    public int getLevelIndexForValue(double speed) {
        int result = -1;
        int i = 0;
        while (i < this.levels.length - 1) {
            double threshold = this.levels[i] + (this.levels[i + 1] - this.levels[i]) / 2.0;
            if (speed < threshold) {
                if (!(threshold - speed <= this.maxDistance * 2.0)) break;
                result = i;
                break;
            }
            ++i;
        }
        if (result == -1 && Math.abs(this.levels[this.levels.length - 1] - speed) <= this.maxDistance) {
            result = this.levels.length - 1;
        }
        return result;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public double getHistogramXValue(int numberOfHistogramColumns, double knots) {
        double minInKnots = this.getMinValueForIndex(this.getLevelIndexForValue(knots));
        double maxInKnots = this.getMaxValueForIndex(this.getLevelIndexForValue(knots));
        double cutMax = maxInKnots - minInKnots;
        double cutValue = knots - minInKnots;
        int columnIndex = (int)(cutValue / cutMax * (double)numberOfHistogramColumns);
        return minInKnots + (double)columnIndex * (cutMax / (double)numberOfHistogramColumns) + 0.5 * (cutMax / (double)numberOfHistogramColumns);
    }

    private double getMinValueForIndex(int levelIndexForValue) {
        double betweenLevels;
        double levelMinusMaxDistance;
        double result = levelIndexForValue == 0 ? ((levelMinusMaxDistance = this.levels[0] - this.maxDistance) > 0.0 ? levelMinusMaxDistance : 0.0) : ((levelMinusMaxDistance = this.levels[levelIndexForValue] - this.maxDistance) > (betweenLevels = this.levels[levelIndexForValue - 1] + (this.levels[levelIndexForValue] - this.levels[levelIndexForValue - 1]) / 2.0) ? levelMinusMaxDistance : betweenLevels);
        return result;
    }

    private double getMaxValueForIndex(int levelIndexForValue) {
        double betweenLevels;
        double levelPlusMaxDistance;
        double result = levelIndexForValue == this.levels.length - 1 ? this.levels[levelIndexForValue] + this.maxDistance : ((levelPlusMaxDistance = this.levels[levelIndexForValue] + this.maxDistance) < (betweenLevels = this.levels[levelIndexForValue] + (this.levels[levelIndexForValue + 1] - this.levels[levelIndexForValue]) / 2.0) ? levelPlusMaxDistance : betweenLevels);
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.maxDistance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindSpeedSteppingWithMaxDistance other = (WindSpeedSteppingWithMaxDistance)obj;
        return Double.doubleToLongBits(this.maxDistance) == Double.doubleToLongBits(other.maxDistance);
    }
}

