/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.PlacemarkOrderDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.dto.RaceLogTrackingInfoDTO;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.dto.NamedDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RaceColumnDTO
extends NamedDTO
implements Serializable {
    private static final long serialVersionUID = -3228244237400937852L;
    private boolean medalRace;
    private List<FleetDTO> fleets;
    private Map<FleetDTO, RegattaAndRaceIdentifier> trackedRaceIdentifiersPerFleet;
    private Map<FleetDTO, RaceDTO> racesPerFleet;
    private Double explicitFactor;
    private double effectiveFactor;
    private boolean oneAlwaysStaysOne;
    private Map<FleetDTO, RaceLogTrackingInfoDTO> raceLogTrackingInfos;

    @Deprecated
    RaceColumnDTO() {
    }

    public RaceColumnDTO(String name, boolean oneAlwaysStaysOne) {
        super(name);
        this.trackedRaceIdentifiersPerFleet = new HashMap<FleetDTO, RegattaAndRaceIdentifier>();
        this.raceLogTrackingInfos = new HashMap<FleetDTO, RaceLogTrackingInfoDTO>();
        this.racesPerFleet = new HashMap<FleetDTO, RaceDTO>();
        this.fleets = new ArrayList<FleetDTO>();
        this.oneAlwaysStaysOne = oneAlwaysStaysOne;
    }

    public RaceColumnLiveState getLiveState(long serverTimePointAsMillis) {
        RaceColumnLiveState result = RaceColumnLiveState.NOT_TRACKED;
        if (this.hasLiveRaces(serverTimePointAsMillis) && this.hasGPSData() && this.hasWindData()) {
            result = RaceColumnLiveState.TRACKED_AND_LIVE;
        } else if (this.hasTrackedRaces()) {
            result = RaceColumnLiveState.TRACKED;
        }
        return result;
    }

    public String getRaceColumnName() {
        return this.getName();
    }

    public Double getExplicitFactor() {
        return this.explicitFactor;
    }

    public void setExplicitFactor(Double explicitFactor) {
        this.explicitFactor = explicitFactor;
    }

    public boolean isOneAlwaysStaysOne() {
        return this.oneAlwaysStaysOne;
    }

    public boolean hasTrackedRace(RaceIdentifier raceIdentifier) {
        return this.trackedRaceIdentifiersPerFleet.values().contains(raceIdentifier);
    }

    public FleetDTO getFleet(RaceIdentifier raceIdentifier) {
        FleetDTO result = null;
        for (FleetDTO identifier : this.trackedRaceIdentifiersPerFleet.keySet()) {
            if (!Util.equalsWithNull((Object)this.trackedRaceIdentifiersPerFleet.get((Object)identifier), (Object)raceIdentifier)) continue;
            result = identifier;
            break;
        }
        return result;
    }

    public boolean isMedalRace() {
        return this.medalRace;
    }

    public void setMedalRace(boolean medalRace) {
        this.medalRace = medalRace;
    }

    public boolean isTrackedRace(FleetDTO fleet) {
        return this.trackedRaceIdentifiersPerFleet.get((Object)fleet) != null;
    }

    public void setRaceIdentifier(FleetDTO fleet, RegattaAndRaceIdentifier raceIdentifier) {
        this.trackedRaceIdentifiersPerFleet.put(fleet, raceIdentifier);
    }

    public RegattaAndRaceIdentifier getRaceIdentifier(FleetDTO fleet) {
        return this.trackedRaceIdentifiersPerFleet.get((Object)fleet);
    }

    public RaceDTO getRace(FleetDTO fleet) {
        return this.racesPerFleet.get((Object)fleet);
    }

    public void setRace(FleetDTO fleet, RaceDTO race) {
        this.racesPerFleet.put(fleet, race);
    }

    public List<FleetDTO> getFleets() {
        return this.fleets;
    }

    public Date getStartDate(FleetDTO fleet) {
        Date start = null;
        RaceDTO raceDTO = this.racesPerFleet.get((Object)fleet);
        if (raceDTO != null && (start = raceDTO.startOfRace) == null && raceDTO.isTracked) {
            start = raceDTO.trackedRace.startOfTracking;
        }
        return start;
    }

    public Date getStartOfTracking(FleetDTO fleet) {
        Date start = null;
        RaceDTO raceDTO = this.racesPerFleet.get((Object)fleet);
        if (raceDTO != null && raceDTO.isTracked) {
            start = raceDTO.trackedRace.startOfTracking;
        }
        return start;
    }

    public Date getEndOfTracking(FleetDTO fleet) {
        Date start = null;
        RaceDTO raceDTO = this.racesPerFleet.get((Object)fleet);
        if (raceDTO != null && raceDTO.isTracked) {
            start = raceDTO.trackedRace.endOfTracking;
        }
        return start;
    }

    public PlacemarkOrderDTO getPlaces() {
        PlacemarkOrderDTO places = null;
        for (RaceDTO race : this.racesPerFleet.values()) {
            if (race == null) continue;
            if (places == null) {
                places = race.places;
                continue;
            }
            places.add(race.places);
        }
        return places;
    }

    public boolean isLive(FleetDTO fleet, long serverTimePointAsMillis) {
        boolean result = false;
        RaceDTO raceDTO = this.racesPerFleet.get((Object)fleet);
        if (raceDTO != null) {
            result = raceDTO.isLive(serverTimePointAsMillis);
        }
        return result;
    }

    public boolean containsRace(RaceIdentifier preSelectedRace) {
        return this.trackedRaceIdentifiersPerFleet.values().contains(preSelectedRace);
    }

    public boolean hasLiveRaces(long serverTimePointAsMillis) {
        boolean result = false;
        for (FleetDTO fleet : this.fleets) {
            result |= this.isLive(fleet, serverTimePointAsMillis);
        }
        return result;
    }

    public boolean hasTrackedRaces() {
        HashSet<RegattaAndRaceIdentifier> raceIdentifiers = new HashSet<RegattaAndRaceIdentifier>(this.trackedRaceIdentifiersPerFleet.values());
        raceIdentifiers.remove(null);
        return !raceIdentifiers.isEmpty();
    }

    public void addFleet(FleetDTO fleet) {
        this.fleets.add(fleet);
    }

    public boolean hasGPSData() {
        for (RaceDTO race : this.racesPerFleet.values()) {
            if (race == null || race.trackedRace == null || !race.trackedRace.hasGPSData) continue;
            return true;
        }
        return false;
    }

    public boolean hasWindData() {
        for (RaceDTO race : this.racesPerFleet.values()) {
            if (race == null || race.trackedRace == null || !race.trackedRace.hasWindData) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.effectiveFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.explicitFactor == null ? 0 : this.explicitFactor.hashCode());
        result = 31 * result + (this.fleets == null ? 0 : this.fleets.hashCode());
        result = 31 * result + (this.medalRace ? 1231 : 1237);
        result = 31 * result + (this.racesPerFleet == null ? 0 : this.racesPerFleet.hashCode());
        result = 31 * result + (this.trackedRaceIdentifiersPerFleet == null ? 0 : this.trackedRaceIdentifiersPerFleet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceColumnDTO other = (RaceColumnDTO)obj;
        if (Double.doubleToLongBits(this.effectiveFactor) != Double.doubleToLongBits(other.effectiveFactor)) {
            return false;
        }
        if (this.explicitFactor == null ? other.explicitFactor != null : !this.explicitFactor.equals(other.explicitFactor)) {
            return false;
        }
        if (this.fleets == null ? other.fleets != null : !this.fleets.equals(other.fleets)) {
            return false;
        }
        if (this.medalRace != other.medalRace) {
            return false;
        }
        if (this.racesPerFleet == null ? other.racesPerFleet != null : !this.racesPerFleet.equals(other.racesPerFleet)) {
            return false;
        }
        return !(this.trackedRaceIdentifiersPerFleet == null ? other.trackedRaceIdentifiersPerFleet != null : !this.trackedRaceIdentifiersPerFleet.equals(other.trackedRaceIdentifiersPerFleet));
    }

    public void setEffectiveFactor(double effectiveFactor) {
        this.effectiveFactor = effectiveFactor;
    }

    public double getEffectiveFactor() {
        return this.effectiveFactor;
    }

    public RaceLogTrackingInfoDTO getRaceLogTrackingInfo(FleetDTO fleet) {
        return this.raceLogTrackingInfos.get((Object)fleet);
    }

    public void setRaceLogTrackingInfo(FleetDTO fleet, RaceLogTrackingInfoDTO info) {
        this.raceLogTrackingInfos.put(fleet, info);
    }

    public String getSeriesName() {
        return "Default";
    }

    public static enum RaceColumnLiveState {
        NOT_TRACKED,
        TRACKED,
        TRACKED_AND_LIVE;

    }
}

