/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.dto.PlacemarkDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PlacemarkOrderDTO
implements Serializable {
    private static final long serialVersionUID = -4981887843843495494L;
    private List<PlacemarkDTO> placemarks;

    public PlacemarkOrderDTO() {
        this.placemarks = new ArrayList<PlacemarkDTO>();
    }

    public PlacemarkOrderDTO(Collection<PlacemarkDTO> placemarks) {
        this.placemarks = new ArrayList<PlacemarkDTO>(placemarks);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.placemarks == null ? 0 : this.placemarks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlacemarkOrderDTO other = (PlacemarkOrderDTO)obj;
        return !(this.placemarks == null ? other.placemarks != null : !this.placemarks.equals(other.placemarks));
    }

    public List<PlacemarkDTO> getPlacemarks() {
        return this.placemarks;
    }

    public List<PlacemarkDTO> getPlacemarksCompressed() {
        ArrayList<PlacemarkDTO> placemarksMerged = new ArrayList<PlacemarkDTO>();
        if (!this.placemarks.isEmpty()) {
            PlacemarkDTO placemarkBefore = this.placemarks.get(0);
            placemarksMerged.add(placemarkBefore);
            int i = 1;
            while (i < this.placemarks.size()) {
                PlacemarkDTO placemark = this.placemarks.get(i);
                if (!placemarkBefore.equals((Object)placemark)) {
                    placemarksMerged.add(placemark);
                    placemarkBefore = placemark;
                }
                ++i;
            }
        }
        return placemarksMerged;
    }

    public void setPlacemarks(Collection<PlacemarkDTO> placemarks) {
        this.placemarks = new ArrayList<PlacemarkDTO>(placemarks);
    }

    public boolean isEmpty() {
        return this.placemarks.isEmpty();
    }

    public String placemarksAsString() {
        StringBuilder sb = new StringBuilder();
        List<PlacemarkDTO> placemarks = this.getPlacemarksCompressed();
        boolean first = true;
        if (!placemarks.isEmpty()) {
            for (PlacemarkDTO placemark : placemarks) {
                if (!first) {
                    sb.append(" -> ");
                }
                sb.append(placemark.asString());
                first = false;
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.placemarks.toString();
    }

    public static String placemarksOfAllOrdersAsMergedString(Iterable<PlacemarkOrderDTO> orders) {
        PlacemarkOrderDTO superOrder = new PlacemarkOrderDTO();
        for (PlacemarkOrderDTO order : orders) {
            superOrder.placemarks.addAll(order.placemarks);
        }
        return superOrder.placemarksAsString();
    }

    public static String placemarksOfAllOrderAsSeperatedString(Iterable<PlacemarkOrderDTO> orders, boolean compressEqualOrders) {
        StringBuilder sb = new StringBuilder();
        Iterator<PlacemarkOrderDTO> ordersIterator = orders.iterator();
        if (ordersIterator.hasNext()) {
            PlacemarkOrderDTO order = ordersIterator.next();
            sb.append(order.placemarksAsString());
            List<PlacemarkDTO> placemarksBefore = null;
            if (compressEqualOrders) {
                placemarksBefore = order.getPlacemarksCompressed();
            }
            while (ordersIterator.hasNext()) {
                order = ordersIterator.next();
                if (compressEqualOrders) {
                    List<PlacemarkDTO> placemarks = order.getPlacemarksCompressed();
                    if (placemarksBefore.equals(placemarks)) continue;
                    sb.append(", ");
                    sb.append(order.placemarksAsString());
                    placemarksBefore = placemarks;
                    continue;
                }
                sb.append(", ");
                sb.append(order.placemarksAsString());
            }
        }
        return sb.toString();
    }

    public void add(PlacemarkOrderDTO places) {
        this.placemarks.addAll(places.getPlacemarks());
    }
}

