/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.settings;

import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.user.client.Window;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.common.settings.serializer.SettingsToStringMapSerializer;
import com.sap.sse.gwt.settings.UrlBuilderUtil;
import java.util.Map;

public class SettingsToUrlSerializer {
    private final SettingsToStringMapSerializer settingsToStringMapSerializer = new SettingsToStringMapSerializer();

    public final String serializeBasedOnCurrentLocation(GenericSerializableSettings settings) {
        UrlBuilder urlBuilder = Window.Location.createUrlBuilder();
        this.serializeToUrlBuilder(settings, urlBuilder);
        return urlBuilder.buildString();
    }

    public final String serializeBasedOnCurrentLocationWithCleanParameters(GenericSerializableSettings settings) {
        UrlBuilder urlBuilder = UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParameters();
        this.serializeToUrlBuilder(settings, urlBuilder);
        return urlBuilder.buildString();
    }

    public final UrlBuilder serializeUrlBuilderBasedOnCurrentLocation(GenericSerializableSettings settings) {
        UrlBuilder urlBuilder = Window.Location.createUrlBuilder();
        this.serializeToUrlBuilder(settings, urlBuilder);
        return urlBuilder;
    }

    public final UrlBuilder serializeUrlBuilderBasedOnCurrentLocationWithCleanParameters(GenericSerializableSettings settings) {
        UrlBuilder urlBuilder = UrlBuilderUtil.createUrlBuilderFromCurrentLocationWithCleanParameters();
        this.serializeToUrlBuilder(settings, urlBuilder);
        return urlBuilder;
    }

    public final void serializeToUrlBuilder(GenericSerializableSettings settings, UrlBuilder urlBuilder) {
        Map serializedValues = this.settingsToStringMapSerializer.serialize(settings);
        this.writeParameterMapToUrlBuilder(urlBuilder, serializedValues);
    }

    public final void serializeSettingsMapToUrlBuilder(SettingsMap settings, UrlBuilder urlBuilder) {
        Map serializedValues = this.settingsToStringMapSerializer.serialize(settings);
        this.writeParameterMapToUrlBuilder(urlBuilder, serializedValues);
    }

    private void writeParameterMapToUrlBuilder(UrlBuilder urlBuilder, Map<String, Iterable<String>> serializedValues) {
        for (Map.Entry<String, Iterable<String>> entry : serializedValues.entrySet()) {
            Iterable<String> parameterValues = entry.getValue();
            String[] parameterValuesAsArray = (String[])Util.toArray(parameterValues, (Object[])new String[Util.size(parameterValues)]);
            if (parameterValuesAsArray.length <= 0) continue;
            urlBuilder.setParameter(entry.getKey(), parameterValuesAsArray);
        }
    }

    public final <T extends GenericSerializableSettings> T deserializeFromCurrentLocation(T settings) {
        Map values = Window.Location.getParameterMap();
        return (T)this.settingsToStringMapSerializer.deserialize(settings, values);
    }

    public final <T extends SettingsMap> T deserializeSettingsMapFromCurrentLocation(T settings) {
        Map values = Window.Location.getParameterMap();
        return (T)this.settingsToStringMapSerializer.deserializeSettingsMap(settings, values);
    }
}

