/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.dispatch.shared.commands;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.gwt.dispatch.shared.caching.HasClientCacheTotalTimeToLive;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import com.sap.sse.gwt.shared.DTO;

public class ResultWithTTL<T extends DTO>
implements Result,
HasClientCacheTotalTimeToLive {
    public static final Duration MAX_TIME_TO_LOAD_EARLIER = Duration.ONE_SECOND.times(5L);
    private Duration ttl;
    private T dto;

    private ResultWithTTL() {
    }

    public ResultWithTTL(long ttl, T dto) {
        this((Duration)new MillisecondsDurationImpl(ttl), dto);
    }

    public ResultWithTTL(Duration ttl, T dto) {
        this.ttl = ttl;
        this.dto = dto;
    }

    public T getDto() {
        return this.dto;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public long getTtlMillis() {
        return this.ttl.asMillis();
    }

    @Override
    public int cacheTotalTimeToLiveMillis() {
        return (int)Math.max(0L, this.getTtlMillis() - MAX_TIME_TO_LOAD_EARLIER.asMillis());
    }
}

