/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.suggestion;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractSuggestOracle<T>
extends SuggestOracle {
    public final void setSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback, Iterable<T> suggestionObjects, Iterable<String> queryTokens) {
        ArrayList<SimpleSuggestion> suggestions = new ArrayList<SimpleSuggestion>();
        ArrayList<String> normalizedQueryTokens = new ArrayList<String>();
        for (String token : queryTokens) {
            normalizedQueryTokens.add(token.toLowerCase());
        }
        int count = 0;
        for (T match : suggestionObjects) {
            suggestions.add(this.createSuggestion(match, normalizedQueryTokens));
            if (++count >= request.getLimit()) break;
        }
        SuggestOracle.Response response = new SuggestOracle.Response(suggestions);
        response.setMoreSuggestionsCount(Util.size(suggestionObjects) - count);
        callback.onSuggestionsReady(request, response);
    }

    protected SimpleSuggestion createSuggestion(T match, Iterable<String> queryTokens) {
        return new SimpleSuggestion(match, queryTokens);
    }

    protected abstract void getSuggestions(SuggestOracle.Request var1, SuggestOracle.Callback var2, Iterable<String> var3);

    protected abstract String createSuggestionKeyString(T var1);

    protected abstract String createSuggestionAdditionalDisplayString(T var1);

    public final void requestDefaultSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        this.getSuggestions(request, callback, Collections.emptyList());
    }

    public final void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        String normalizedQuery = request.getQuery().trim();
        if (normalizedQuery == null || normalizedQuery.isEmpty()) {
            this.requestDefaultSuggestions(request, callback);
        } else {
            Iterable queryTokens = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)normalizedQuery);
            this.getSuggestions(request, callback, queryTokens);
        }
    }

    public final boolean isDisplayStringHTML() {
        return true;
    }

    public class SimpleSuggestion
    implements SuggestOracle.Suggestion {
        private static final String STRONG_TAG_OPEN = "<strong>";
        private static final String STRONG_TAG_CLOSE = "</strong>";
        private static final String ITALIC_TAG_OPEN = "<em>";
        private static final String ITALIC_TAG_CLOSE = "</em>";
        private final T suggestObject;
        private final Iterable<String> queryTokens;

        public SimpleSuggestion(T suggestObject, Iterable<String> queryTokens) {
            this.suggestObject = suggestObject;
            this.queryTokens = queryTokens;
        }

        public String getDisplayString() {
            SafeHtmlBuilder builder = new SafeHtmlBuilder();
            this.appendHighlighted(builder, AbstractSuggestOracle.this.createSuggestionKeyString(this.suggestObject));
            String additionalString = AbstractSuggestOracle.this.createSuggestionAdditionalDisplayString(this.suggestObject);
            if (additionalString != null && !additionalString.isEmpty()) {
                builder.append(SafeHtmlUtils.fromTrustedString((String)ITALIC_TAG_OPEN));
                builder.append(SafeHtmlUtils.fromSafeConstant((String)" - "));
                this.appendHighlighted(builder, additionalString);
                builder.append(SafeHtmlUtils.fromTrustedString((String)ITALIC_TAG_CLOSE));
            }
            return builder.toSafeHtml().asString();
        }

        private void appendHighlighted(SafeHtmlBuilder builder, String displayString) {
            String normalizedString = displayString.toLowerCase();
            int cursor = 0;
            while (true) {
                int index = displayString.length();
                String matchToken = null;
                for (String token : this.queryTokens) {
                    int matchIndex;
                    if (token == null || token.isEmpty() || (matchIndex = normalizedString.indexOf(token, cursor)) < 0 || matchIndex >= index) continue;
                    index = matchIndex;
                    matchToken = token;
                }
                if (matchToken == null) break;
                builder.appendEscaped(displayString.substring(cursor, index));
                builder.append(SafeHtmlUtils.fromTrustedString((String)STRONG_TAG_OPEN));
                builder.appendEscaped(displayString.substring(index, index + matchToken.length()));
                builder.append(SafeHtmlUtils.fromTrustedString((String)STRONG_TAG_CLOSE));
                cursor = index + matchToken.length();
            }
            builder.appendEscaped(displayString.substring(cursor));
        }

        public String getReplacementString() {
            return AbstractSuggestOracle.this.createSuggestionKeyString(this.suggestObject);
        }

        public T getSuggestObject() {
            return this.suggestObject;
        }
    }
}

