/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.shared.components;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Color;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.LinkWithSettingsGenerator;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;

public abstract class AbstractSettingsDialog<SettingsType extends Settings>
extends DataEntryDialog<SettingsType> {
    private SettingsDialogComponent<SettingsType> settingsDialogComponent;
    private LinkWithSettingsGenerator<SettingsType> linkWithSettingsGenerator;
    private ShareLinkAnchor shareAnchor;
    private SimplePanel sp;

    protected AbstractSettingsDialog(String shortName, SettingsDialogComponent<SettingsType> dialogComponent, StringMessages stringMessages, boolean animationEnabled, LinkWithSettingsGenerator<SettingsType> linkWithSettingsGenerator, DataEntryDialog.DialogCallback<SettingsType> callback) {
        super(stringMessages.settingsForComponent(shortName), null, stringMessages.ok(), stringMessages.cancel(), dialogComponent.getValidator(), animationEnabled, callback != null ? callback : new NoOpDialogCallback());
        this.settingsDialogComponent = dialogComponent;
        this.sp = new SimplePanel();
        this.linkWithSettingsGenerator = linkWithSettingsGenerator;
        if (linkWithSettingsGenerator != null) {
            this.shareAnchor = new ShareLinkAnchor(stringMessages.sharedSettingsLink(), this.getLeftButtonPannel());
            this.shareAnchor.setEnabled(true);
            Scheduler.get().scheduleDeferred(() -> this.onChange(this.getResult()));
        }
        this.sp.setWidget(dialogComponent.getAdditionalWidget(this));
    }

    void setDialogComponent(SettingsDialogComponent<SettingsType> dialog) {
        this.sp.setWidget(dialog.getAdditionalWidget(this));
        this.settingsDialogComponent = dialog;
        this.setValidator(dialog.getValidator());
        this.validateAndUpdate();
    }

    @Override
    protected void onChange(SettingsType result) {
        if (this.linkWithSettingsGenerator != null) {
            String link = this.linkWithSettingsGenerator.createUrl(result);
            this.shareAnchor.setHref(link);
        }
    }

    @Override
    protected void onInvalidStateChanged(boolean invalidState) {
        super.onInvalidStateChanged(invalidState);
        if (this.linkWithSettingsGenerator != null) {
            this.shareAnchor.setEnabled(!invalidState);
        }
    }

    @Override
    protected Widget getAdditionalWidget() {
        return this.sp;
    }

    @Override
    public SettingsType getResult() {
        return this.settingsDialogComponent.getResult();
    }

    @Override
    protected Focusable getInitialFocusWidget() {
        return this.settingsDialogComponent.getFocusWidget();
    }

    private static class NoOpDialogCallback<SettingsType extends Settings>
    implements DataEntryDialog.DialogCallback<SettingsType> {
        private NoOpDialogCallback() {
        }

        @Override
        public void ok(SettingsType editedObject) {
        }

        @Override
        public void cancel() {
        }
    }

    private class ShareLinkAnchor
    implements HasEnabled {
        private final FlowPanel container = new FlowPanel();
        private final Anchor anchor;
        private final Label placeholder;

        private ShareLinkAnchor(String anchorText, FlowPanel parent) {
            this.container.getElement().getStyle().setMargin(0.5, Style.Unit.EM);
            this.container.getElement().getStyle().setDisplay(Style.Display.INLINE_BLOCK);
            this.anchor = this.createEnabledAnchor(anchorText);
            this.placeholder = this.createDisabledPlaceholder(anchorText);
            this.container.add((Widget)this.anchor);
            this.container.add((Widget)this.placeholder);
            parent.add((Widget)this.container);
        }

        private Anchor createEnabledAnchor(String anchorText) {
            Anchor anchor = new Anchor(anchorText);
            anchor.ensureDebugId("ShareAnchor");
            anchor.setTarget("_blank");
            anchor.getElement().getStyle().setDisplay(Style.Display.INLINE_BLOCK);
            return anchor;
        }

        private Label createDisabledPlaceholder(String anchorText) {
            Label placeholder = new Label(anchorText);
            placeholder.ensureDebugId("ShareAnchorDiabled");
            placeholder.getElement().getStyle().setDisplay(Style.Display.INLINE_BLOCK);
            placeholder.getElement().getStyle().setColor(Color.LIGHT_GRAY.getAsHtml());
            placeholder.getElement().getStyle().setCursor(Style.Cursor.DEFAULT);
            return placeholder;
        }

        private void setHref(String href) {
            this.anchor.setHref(href);
        }

        public boolean isEnabled() {
            return this.anchor.isVisible() && !this.placeholder.isVisible();
        }

        public void setEnabled(boolean enabled) {
            this.anchor.setVisible(enabled);
            this.placeholder.setVisible(!enabled);
        }
    }
}

