/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.dialog;

import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SuggestBox;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public abstract class DialogUtils {
    public static void linkEnterToButton(final Button button, HasAllKeyHandlers ... widgets) {
        HasAllKeyHandlers[] hasAllKeyHandlersArray = widgets;
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            HasAllKeyHandlers widget = hasAllKeyHandlersArray[n2];
            widget.addKeyPressHandler(new KeyPressHandler(){

                public void onKeyPress(KeyPressEvent event) {
                    if (event.getNativeEvent().getKeyCode() == 13) {
                        button.click();
                    }
                }
            });
            ++n2;
        }
    }

    public static void linkEscapeToButton(final Button button, HasAllKeyHandlers ... widgets) {
        if (button != null) {
            HasAllKeyHandlers[] hasAllKeyHandlersArray = widgets;
            int n = widgets.length;
            int n2 = 0;
            while (n2 < n) {
                HasAllKeyHandlers widget = hasAllKeyHandlersArray[n2];
                widget.addKeyPressHandler(new KeyPressHandler(){

                    public void onKeyPress(KeyPressEvent event) {
                        if (event.getNativeEvent().getKeyCode() == 27) {
                            button.click();
                        }
                    }
                });
                widget.addKeyUpHandler(new KeyUpHandler(){

                    public void onKeyUp(KeyUpEvent event) {
                        if (event.getNativeEvent().getKeyCode() == 27) {
                            button.click();
                        }
                    }
                });
                ++n2;
            }
        }
    }

    public static void addFocusUponKeyUpToggler(SuggestBox focusable) {
        focusable.addKeyUpHandler(e -> {
            focusable.setFocus(false);
            focusable.setFocus(true);
        });
    }

    public static void addFocusUponKeyUpToggler(final FocusWidget focusable) {
        focusable.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                focusable.setFocus(false);
                focusable.setFocus(true);
            }
        });
    }

    public static void makeCountrySelection(ListBox threeLetterIocCountryCode, String threeLetterIocCountryCodeToSelect) {
        CountryCodeFactory ccf = CountryCodeFactory.INSTANCE;
        int i = 0;
        ArrayList ccs = new ArrayList();
        Util.addAll((Iterable)ccf.getAll(), ccs);
        ccs.add(null);
        Collections.sort(ccs, new Comparator<CountryCode>(){

            @Override
            public int compare(CountryCode o1, CountryCode o2) {
                return Util.compareToWithNull((Comparable)((Object)(o1 == null ? null : o1.getThreeLetterIOCCode())), (Comparable)((Object)(o2 == null ? null : o2.getThreeLetterIOCCode())), (boolean)true);
            }
        });
        for (CountryCode cc : ccs) {
            if (cc == null) {
                threeLetterIocCountryCode.addItem("", "");
                if (threeLetterIocCountryCodeToSelect == null || threeLetterIocCountryCodeToSelect.isEmpty()) {
                    threeLetterIocCountryCode.setSelectedIndex(i);
                }
                ++i;
                continue;
            }
            if (cc.getThreeLetterIOCCode() == null) continue;
            threeLetterIocCountryCode.addItem(String.valueOf(cc.getThreeLetterIOCCode()) + " " + cc.getName(), cc.getThreeLetterIOCCode());
            if (cc.getThreeLetterIOCCode().equals(threeLetterIocCountryCodeToSelect)) {
                threeLetterIocCountryCode.setSelectedIndex(i);
            }
            ++i;
        }
    }

    public static CountryCode getSelectedCountry(ListBox issuingCountryListBox) {
        return issuingCountryListBox.getSelectedIndex() == -1 ? null : CountryCodeFactory.INSTANCE.getFromThreeLetterIOCName(issuingCountryListBox.getSelectedValue());
    }
}

