/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.slider;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.DOM;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.controls.slider.SliderBar;
import com.sap.sse.gwt.client.controls.slider.TimeTicksCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TimeSlider
extends SliderBar {
    private final TimeTicksCalculator calc = new TimeTicksCalculator();
    private List<TimeTicksCalculator.TickPosition> calculatedTimeTicks;
    private boolean isZoomed = false;
    private int visibleLabelsInterval = 1;
    private final int TICKCOUNT = 10;
    private List<BarOverlay> overlays;
    private List<Element> overLayElements = new ArrayList<Element>();
    private TimeTicksCalculator.NormalizedInterval normalizedTimeTickInterval;

    public TimeSlider() {
        this.calculatedTimeTicks = new ArrayList<TimeTicksCalculator.TickPosition>();
        this.overlays = new ArrayList<BarOverlay>();
    }

    private void calculateTicks() {
        if (this.isMinMaxInitialized()) {
            this.calculatedTimeTicks.clear();
            long minMaxDiffInMs = this.maxValue.longValue() - this.minValue.longValue();
            long tickInterval = minMaxDiffInMs / 10L;
            this.normalizedTimeTickInterval = this.calc.normalizeTimeTickInterval(tickInterval);
            this.calculatedTimeTicks = this.calc.calculateTimeTicks(this.normalizedTimeTickInterval, this.minValue.longValue(), this.maxValue.longValue(), 1L);
        }
    }

    @Override
    protected void drawTicks() {
        if (this.isAttached() && this.isMinMaxInitialized()) {
            int lineWidth = this.lineElement.getOffsetWidth();
            int i = 0;
            while (i < this.calculatedTimeTicks.size()) {
                TimeTicksCalculator.TickPosition tickPosition = this.calculatedTimeTicks.get(i);
                com.google.gwt.user.client.Element tick = null;
                if (i < this.tickElements.size()) {
                    tick = (Element)this.tickElements.get(i);
                } else {
                    tick = DOM.createDiv();
                    tick.getStyle().setPosition(Style.Position.ABSOLUTE);
                    tick.getStyle().setDisplay(Style.Display.NONE);
                    DOM.appendChild((Element)this.getElement(), (Element)tick);
                    this.tickElements.add(tick);
                }
                if (this.enabled) {
                    tick.setPropertyString("className", "gwt-SliderBar-tick");
                } else {
                    tick.setPropertyString("className", "gwt-SliderBar-tick gwt-SliderBar-tick-disabled");
                }
                tick.getStyle().setVisibility(Style.Visibility.HIDDEN);
                tick.getStyle().setProperty("display", "");
                int tickWidth = tick.getOffsetWidth();
                if (!this.maxValue.equals(this.minValue)) {
                    long pos = (tickPosition.getPosition().getTime() - this.minValue.longValue()) * (long)lineWidth / (this.maxValue.longValue() - this.minValue.longValue());
                    int tickLeftOffset = this.lineLeftOffset + (int)pos - tickWidth / 2;
                    tickLeftOffset = Math.min(tickLeftOffset, this.lineLeftOffset + lineWidth - tickWidth);
                    tick.getStyle().setLeft((double)tickLeftOffset, Style.Unit.PX);
                    tick.getStyle().setVisibility(this.isTickInVisibleRange(tickPosition) ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
                }
                ++i;
            }
            i = this.calculatedTimeTicks.size();
            while (i < this.tickElements.size()) {
                ((Element)this.tickElements.get(i)).getStyle().setDisplay(Style.Display.NONE);
                ++i;
            }
        }
    }

    @Override
    protected void drawTickLabels() {
        if (this.isAttached() && this.isMinMaxInitialized()) {
            int lineWidth = this.lineElement.getOffsetWidth();
            Double previousValue = null;
            int i = 0;
            int ticksInVisibleRange = 0;
            while (i < this.calculatedTimeTicks.size()) {
                TimeTicksCalculator.TickPosition tickPosition = this.calculatedTimeTicks.get(i);
                com.google.gwt.user.client.Element label = null;
                if (i < this.tickLabelElements.size()) {
                    label = (Element)this.tickLabelElements.get(i);
                } else {
                    label = DOM.createDiv();
                    label.getStyle().setPosition(Style.Position.ABSOLUTE);
                    label.getStyle().setDisplay(Style.Display.NONE);
                    if (this.enabled) {
                        label.setPropertyString("className", "gwt-SliderBar-ticklabel");
                    } else {
                        label.setPropertyString("className", "gwt-SliderBar-ticklabel-disabled");
                    }
                    DOM.appendChild((Element)this.getElement(), (Element)label);
                    this.tickLabelElements.add(label);
                }
                double value = tickPosition.getPosition().getTime();
                label.getStyle().setVisibility(Style.Visibility.HIDDEN);
                label.getStyle().setProperty("display", "");
                label.setPropertyString("innerHTML", this.formatTickLabel(value, previousValue));
                label.getStyle().setLeft(0.0, Style.Unit.PX);
                int labelWidth = label.getOffsetWidth();
                if (!this.maxValue.equals(this.minValue)) {
                    long pos = (tickPosition.getPosition().getTime() - this.minValue.longValue()) * (long)lineWidth / (this.maxValue.longValue() - this.minValue.longValue());
                    int labelLeftOffset = this.lineLeftOffset + (int)pos - labelWidth / 2;
                    labelLeftOffset = Math.min(labelLeftOffset, this.lineLeftOffset + lineWidth - labelWidth);
                    labelLeftOffset = Math.max(labelLeftOffset, this.lineLeftOffset);
                    label.getStyle().setLeft((double)labelLeftOffset, Style.Unit.PX);
                    boolean visible = this.isTickInVisibleRange(tickPosition) && ticksInVisibleRange++ % this.visibleLabelsInterval == 0;
                    label.getStyle().setVisibility(visible ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
                }
                previousValue = value;
                ++i;
            }
            i = this.calculatedTimeTicks.size();
            while (i < this.tickLabelElements.size()) {
                ((Element)this.tickLabelElements.get(i)).getStyle().setDisplay(Style.Display.NONE);
                ++i;
            }
        }
    }

    private boolean isTickInVisibleRange(TimeTicksCalculator.TickPosition tickPosition) {
        long tickValue = tickPosition.getPosition().getTime();
        return (double)tickValue >= this.minValue && (double)tickValue <= this.maxValue;
    }

    public void clearMarkersAndLabelsAndTicks() {
        this.clearMarkers();
        for (Element elem : this.tickLabelElements) {
            elem.getStyle().setDisplay(Style.Display.NONE);
            elem.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
        for (Element elem : this.tickElements) {
            elem.getStyle().setDisplay(Style.Display.NONE);
            elem.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
        for (Element elem : this.markerLabelElements) {
            elem.getStyle().setDisplay(Style.Display.NONE);
            elem.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
        for (Element elem : this.markerElements) {
            elem.getStyle().setDisplay(Style.Display.NONE);
            elem.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
    }

    @Override
    protected void drawKnob() {
        if (!this.isAttached() || !this.isMinMaxInitialized()) {
            return;
        }
        com.google.gwt.user.client.Element knobElement = this.knobImage.getElement();
        if (this.curValue != null && this.minValue != null && this.maxValue != null && this.curValue >= this.minValue && this.curValue <= this.maxValue) {
            int lineWidth = this.lineElement.getOffsetWidth();
            int knobWidth = knobElement.getOffsetWidth();
            int knobLeftOffset = (int)((double)this.lineLeftOffset + this.getKnobPercent() * (double)lineWidth - (double)(knobWidth / 2));
            knobLeftOffset = Math.min(knobLeftOffset, this.lineLeftOffset + lineWidth - knobWidth / 2 - 1);
            knobElement.getStyle().setLeft((double)knobLeftOffset, Style.Unit.PX);
            knobElement.getStyle().setVisibility(Style.Visibility.VISIBLE);
            knobElement.getStyle().setProperty("display", "");
            knobElement.setAttribute("selenium-id", "sliderKnob");
            knobElement.setTitle(this.formatTickLabel(this.curValue, null));
        } else {
            knobElement.getStyle().setDisplay(Style.Display.NONE);
            knobElement.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
    }

    @Override
    public void setMaxValue(Double maxValue, boolean fireEvent) {
        if (!this.isZoomed) {
            super.setMaxValue(maxValue, fireEvent);
        } else {
            this.maxValue = maxValue;
        }
    }

    @Override
    public void setMinValue(Double minValue, boolean fireEvent) {
        if (!this.isZoomed) {
            super.setMinValue(minValue, fireEvent);
        } else {
            this.minValue = minValue;
        }
    }

    @Override
    public Optional<Util.Pair<Double, Double>> setMinAndMaxValue(Double minValue, Double maxValue, boolean fireEvent) {
        Optional<Object> result;
        if (!this.isZoomed) {
            Double minLimited = minValue;
            if (minValue != null && this.minValue != null) {
                minLimited = Double.min(minValue, this.minValue);
            }
            Double maxLimited = maxValue;
            if (maxValue != null && this.maxValue != null) {
                maxLimited = Double.max(maxValue, this.maxValue);
            }
            result = super.setMinAndMaxValue(minLimited, maxLimited, fireEvent);
        } else {
            boolean minChanged = !Util.equalsWithNull((Object)this.minValue, (Object)minValue);
            this.minValue = minValue;
            boolean maxChanged = !Util.equalsWithNull((Object)this.maxValue, (Object)maxValue);
            this.maxValue = maxValue;
            result = minChanged || maxChanged ? Optional.of(new Util.Pair((Object)this.minValue, (Object)this.maxValue)) : Optional.empty();
        }
        return result;
    }

    @Override
    protected void onMinMaxValueChanged(boolean fireEvent) {
        this.calculateTicks();
        super.onMinMaxValueChanged(fireEvent);
    }

    @Override
    public void setStepSize(double stepSize, boolean fireEvent) {
        if (!this.isZoomed) {
            super.setStepSize(stepSize, fireEvent);
        } else {
            this.stepSize = stepSize;
        }
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public void setZoomed(boolean isZoomed) {
        this.isZoomed = isZoomed;
    }

    @Override
    public void onResize() {
        this.visibleLabelsInterval = 10 / Math.max(this.getOffsetWidth() / 35, 1) + 1;
        this.drawBarOverlays();
        super.onResize();
    }

    public void setBarOverlays(Iterable<BarOverlay> overlays) {
        this.overlays.clear();
        Util.addAll(overlays, this.overlays);
    }

    private void drawBarOverlays() {
        block8: {
            if (!this.isAttached() || !this.isMinMaxInitialized()) break block8;
            int numOverlays = this.overlays.size();
            int lineWidth = this.lineElement.getOffsetWidth();
            if (numOverlays > 0) {
                int trackHeight = 4;
                HashMap<BarOverlay, Integer> knownLevels = new HashMap<BarOverlay, Integer>();
                int i = 0;
                while (i < numOverlays) {
                    BarOverlay overlay = this.overlays.get(i);
                    com.google.gwt.user.client.Element overlayElem = null;
                    if (i < this.overLayElements.size()) {
                        overlayElem = this.overLayElements.get(i);
                    } else {
                        overlayElem = DOM.createDiv();
                        overlayElem.getStyle().setPosition(Style.Position.ABSOLUTE);
                        overlayElem.getStyle().setDisplay(Style.Display.NONE);
                        DOM.insertChild((Element)this.getElement(), (Element)overlayElem, (int)0);
                        this.overLayElements.add((Element)overlayElem);
                    }
                    overlayElem.getStyle().setVisibility(Style.Visibility.HIDDEN);
                    overlayElem.getStyle().setProperty("display", "");
                    overlayElem.setTitle(overlay.info);
                    double markerStartLinePosition = (overlay.start - this.minValue) * (double)lineWidth / this.getTotalRange();
                    double end = overlay.end;
                    if (this.maxValue < overlay.end) {
                        end = this.maxValue;
                    }
                    double markerEndLinePosition = (this.maxValue - end) * (double)lineWidth / this.getTotalRange();
                    overlayElem.getStyle().setLeft(Math.max(0.0, markerStartLinePosition + (double)this.lineLeftOffset), Style.Unit.PX);
                    overlayElem.getStyle().setRight(markerEndLinePosition, Style.Unit.PX);
                    overlayElem.getStyle().setHeight((double)trackHeight, Style.Unit.PX);
                    int level = this.determineBestLevel(overlay.start, overlay.end, knownLevels);
                    knownLevels.put(overlay, level);
                    overlayElem.getStyle().setTop((double)(32 + level * (trackHeight + 1)), Style.Unit.PX);
                    overlayElem.getStyle().setBackgroundColor(overlay.running ? "#FF0000" : "#CCCCCC");
                    overlayElem.getStyle().setVisibility(Style.Visibility.VISIBLE);
                    ++i;
                }
                i = numOverlays;
                while (i < this.overLayElements.size()) {
                    this.overLayElements.get(i).getStyle().setDisplay(Style.Display.NONE);
                    ++i;
                }
            } else {
                for (Element elem : this.overLayElements) {
                    elem.getStyle().setDisplay(Style.Display.NONE);
                }
            }
        }
    }

    private int determineBestLevel(Double start, Double end, Map<BarOverlay, Integer> knownHeights) {
        int bestCollisionLevel = 0;
        int bestCollisionCount = Integer.MAX_VALUE;
        int testLevel = 0;
        while (testLevel < 5) {
            int collisionCount = 0;
            for (Map.Entry<BarOverlay, Integer> possibleCollision : knownHeights.entrySet()) {
                if (possibleCollision.getValue() != testLevel || !(possibleCollision.getKey().start <= end) || !(possibleCollision.getKey().end >= start)) continue;
                ++collisionCount;
            }
            if (collisionCount < bestCollisionCount) {
                bestCollisionLevel = testLevel;
                bestCollisionCount = collisionCount;
            }
            ++testLevel;
        }
        return bestCollisionLevel;
    }

    public static class BarOverlay {
        public final Double start;
        public final Double end;
        public final boolean running;
        public final String info;

        public BarOverlay(Double start, Double end, boolean running, String info) {
            this.start = start;
            this.end = end;
            this.running = running;
            this.info = info;
        }
    }
}

