/*
 * Decompiled with CFR 0.152.
 */
package com.tractrac.subscription.app.tracapi;

import com.tractrac.model.lib.api.ModelLocator;
import com.tractrac.model.lib.api.event.CreateModelException;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IEventFactory;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.RaceLoadingException;
import com.tractrac.subscription.app.tracapi.EventListener;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.ISubscriberFactory;
import com.tractrac.subscription.lib.api.SubscriberInitializationException;
import com.tractrac.subscription.lib.api.SubscriptionLocator;
import com.tractrac.subscription.lib.api.competitor.ICompetitorSensorDataListener;
import com.tractrac.subscription.lib.api.competitor.ICompetitorsListener;
import com.tractrac.subscription.lib.api.competitor.IPositionListener;
import com.tractrac.subscription.lib.api.control.IControlPassingsListener;
import com.tractrac.subscription.lib.api.control.IControlRouteChangeListener;
import com.tractrac.subscription.lib.api.event.IConnectionStatusListener;
import com.tractrac.subscription.lib.api.event.IEventMessageListener;
import com.tractrac.subscription.lib.api.map.IMapItemsListener;
import com.tractrac.subscription.lib.api.map.IPositionedItemPositionListener;
import com.tractrac.subscription.lib.api.race.IRaceCompetitorListener;
import com.tractrac.subscription.lib.api.race.IRaceMessageListener;
import com.tractrac.subscription.lib.api.race.IRaceStartStopTimesChangeListener;
import com.tractrac.subscription.lib.api.race.IRacesListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class ConnectToAllRaces {
    public static void main(String[] args) throws CreateModelException, URISyntaxException, SubscriberInitializationException, IOException, RaceLoadingException {
        URI paramURI = new URI("https://event.tractrac.com/events/event_20140429_ESSQingdao/jsonservice.php");
        String apiToken = args[0];
        IEventFactory eventFactory = ModelLocator.getEventFactory();
        IEvent event = eventFactory.createEvent(apiToken, paramURI);
        ArrayList<IRaceSubscriber> raceSubscriberList = new ArrayList<IRaceSubscriber>();
        ISubscriberFactory subscriberFactory = SubscriptionLocator.getSusbcriberFactory();
        EventListener listener = new EventListener();
        IEventSubscriber eventSubscriber = subscriberFactory.createEventSubscriber(apiToken, event);
        eventSubscriber.subscribeConnectionStatus((IConnectionStatusListener)listener);
        eventSubscriber.subscribeEventMessages((IEventMessageListener)listener);
        eventSubscriber.subscribeRaces((IRacesListener)listener);
        eventSubscriber.subscribeMapItems((IMapItemsListener)listener);
        eventSubscriber.subscribeCompetitors((ICompetitorsListener)listener);
        for (IRace race : event.getRaces()) {
            race.reloadFromServer();
            listener = new EventListener();
            listener.setRace(race);
            IRaceSubscriber raceSubscriber = subscriberFactory.createRaceSubscriber(apiToken, race);
            raceSubscriber.subscribeConnectionStatus((IConnectionStatusListener)listener);
            raceSubscriber.subscribePositionedItemPositions((IPositionedItemPositionListener)listener);
            raceSubscriber.subscribePositions((IPositionListener)listener);
            raceSubscriber.subscribeControlPassings((IControlPassingsListener)listener);
            raceSubscriber.subscribeCompetitorSensorData((ICompetitorSensorDataListener)listener);
            raceSubscriber.subscribeRaceMessages((IRaceMessageListener)listener);
            raceSubscriber.subscribeRaceTimesChanges((IRaceStartStopTimesChangeListener)listener);
            raceSubscriber.subscribeRouteChanges((IControlRouteChangeListener)listener);
            raceSubscriber.subscribeRaceCompetitor((IRaceCompetitorListener)listener);
            raceSubscriber.start();
            raceSubscriberList.add(raceSubscriber);
        }
        eventSubscriber.start();
        System.out.println("Press key to cancel live data stream");
        System.in.read();
        System.out.println("Cancelling data stream");
        for (IRaceSubscriber raceSubscriber : raceSubscriberList) {
            raceSubscriber.stop();
        }
        eventSubscriber.stop();
    }
}

