/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;

public class InsertManeuverStatement
extends AbstractPreparedInsertStatement<ManeuverTrackedRaceAndCompetitor> {
    protected InsertManeuverStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"Maneuver\" (\"race\", \"regatta\", \"competitorId\", \"timepoint\", \"type\", \"newTack\", \"lossInMeters\", \"speedBeforeInKnots\", \"speedAfterInKnots\", \"courseBeforeInTrueDegrees\", \"courseAfterInTrueDegrees\", \"directionChangeInDegrees\", \"maximumTurningRateInDegreesPerSecond\", \"lowestSpeedInKnots\", \"toSide\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(ManeuverTrackedRaceAndCompetitor maneuverTrackedRaceAndCompetitor) throws SQLException {
        this.getPreparedStatement().setString(1, maneuverTrackedRaceAndCompetitor.getTrackedRace().getRace().getName());
        this.getPreparedStatement().setString(2, maneuverTrackedRaceAndCompetitor.getTrackedRace().getTrackedRegatta().getRegatta().getName());
        this.getPreparedStatement().setString(3, maneuverTrackedRaceAndCompetitor.getCompetitor().getId().toString());
        this.getPreparedStatement().setDate(4, new Date(maneuverTrackedRaceAndCompetitor.getManeuver().getTimePoint().asMillis()));
        this.getPreparedStatement().setString(5, maneuverTrackedRaceAndCompetitor.getManeuver().getType().name());
        this.getPreparedStatement().setString(6, maneuverTrackedRaceAndCompetitor.getManeuver().getNewTack().name());
        if (maneuverTrackedRaceAndCompetitor.getManeuver().getManeuverLoss() != null) {
            this.setDouble(7, maneuverTrackedRaceAndCompetitor.getManeuver().getManeuverLoss().getDistanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle().getMeters() - maneuverTrackedRaceAndCompetitor.getManeuver().getManeuverLoss().getDistanceSailedProjectedOnMiddleManeuverAngle().getMeters());
        } else {
            this.setDouble(7, 0.0);
        }
        this.setDouble(8, maneuverTrackedRaceAndCompetitor.getManeuver().getSpeedWithBearingBefore().getKnots());
        this.setDouble(9, maneuverTrackedRaceAndCompetitor.getManeuver().getSpeedWithBearingAfter().getKnots());
        this.setDouble(10, maneuverTrackedRaceAndCompetitor.getManeuver().getSpeedWithBearingBefore().getBearing().getDegrees());
        this.setDouble(11, maneuverTrackedRaceAndCompetitor.getManeuver().getSpeedWithBearingAfter().getBearing().getDegrees());
        this.setDouble(12, maneuverTrackedRaceAndCompetitor.getManeuver().getDirectionChangeInDegrees());
        this.setDouble(13, maneuverTrackedRaceAndCompetitor.getManeuver().getMaxTurningRateInDegreesPerSecond());
        this.setDouble(14, maneuverTrackedRaceAndCompetitor.getManeuver().getLowestSpeed().getKnots());
        this.getPreparedStatement().setString(15, maneuverTrackedRaceAndCompetitor.getManeuver().getToSide().name());
    }

    static class ManeuverTrackedRaceAndCompetitor {
        private final Maneuver maneuver;
        private final TrackedRace trackedRace;
        private final Competitor competitor;

        public ManeuverTrackedRaceAndCompetitor(Maneuver maneuver, TrackedRace trackedRace, Competitor competitor) {
            this.maneuver = maneuver;
            this.trackedRace = trackedRace;
            this.competitor = competitor;
        }

        public Maneuver getManeuver() {
            return this.maneuver;
        }

        public TrackedRace getTrackedRace() {
            return this.trackedRace;
        }

        public Competitor getCompetitor() {
            return this.competitor;
        }
    }
}

