/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRacingEventServiceOperation;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;

public class RemoveLeaderboardGroupFromEvent
extends AbstractRacingEventServiceOperation<Boolean> {
    private static final long serialVersionUID = 5061411909275963501L;
    private static Logger logger = Logger.getLogger(RemoveLeaderboardGroupFromEvent.class.getName());
    private final UUID eventId;
    private final UUID[] leaderboardGroupIds;

    public RemoveLeaderboardGroupFromEvent(UUID eventId, UUID ... leaderboardGroupIds) {
        this.eventId = eventId;
        this.leaderboardGroupIds = leaderboardGroupIds;
    }

    public Boolean internalApplyTo(RacingEventService toState) {
        boolean updated = false;
        Event event = toState.getEvent(this.eventId);
        if (event != null) {
            UUID[] uUIDArray = this.leaderboardGroupIds;
            int n = this.leaderboardGroupIds.length;
            int n2 = 0;
            while (n2 < n) {
                UUID leaderboardGroupId = uUIDArray[n2];
                LeaderboardGroup leaderboardGroup = toState.getLeaderboardGroupByID(leaderboardGroupId);
                if (leaderboardGroup != null) {
                    event.removeLeaderboardGroup(leaderboardGroup);
                    updated = true;
                } else {
                    logger.info("Leaderboard group with ID " + leaderboardGroupId + " not found. Cannot remove leaderboard group from event with ID " + this.eventId);
                }
                ++n2;
            }
        } else {
            logger.info("Event with ID " + this.eventId + " not found. Cannot remove leaderboard groups with IDs " + Arrays.toString(this.leaderboardGroupIds) + " from it.");
        }
        if (updated) {
            toState.getMongoObjectFactory().storeEvent(event);
        }
        return updated;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

