/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Util;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JvmUtils {
    public static Optional<Integer> getMegabytesFromJvmSize(String memoryVariable) {
        Integer result;
        Matcher m = Pattern.compile("([0-9][0-9]*)([mMgG]?)").matcher(memoryVariable);
        if (m.matches()) {
            if (m.group(2).equalsIgnoreCase("m")) {
                result = Integer.valueOf(m.group(1));
            } else if (m.group(2).equalsIgnoreCase("g")) {
                result = Integer.valueOf(m.group(1)) * 1024;
            } else if (!Util.hasLength((String)m.group(2))) {
                int mod = Integer.valueOf(m.group(1)) % 0x100000;
                result = Integer.valueOf(m.group(1)) / 1024 / 1024 + (mod == 0 ? 0 : 1);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return Optional.ofNullable(result);
    }
}

