/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A security group rule removed with <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupEgress.html"
 * >RevokeSecurityGroupEgress</a> or <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RevokeSecurityGroupIngress.html"
 * >RevokeSecurityGroupIngress</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokedSecurityGroupRule implements SdkPojo, Serializable,
        ToCopyableBuilder<RevokedSecurityGroupRule.Builder, RevokedSecurityGroupRule> {
    private static final SdkField<String> SECURITY_GROUP_RULE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecurityGroupRuleId")
            .getter(getter(RevokedSecurityGroupRule::securityGroupRuleId))
            .setter(setter(Builder::securityGroupRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleId")
                    .unmarshallLocationName("securityGroupRuleId").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(RevokedSecurityGroupRule::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<Boolean> IS_EGRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEgress")
            .getter(getter(RevokedSecurityGroupRule::isEgress))
            .setter(setter(Builder::isEgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEgress")
                    .unmarshallLocationName("isEgress").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(RevokedSecurityGroupRule::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(RevokedSecurityGroupRule::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(RevokedSecurityGroupRule::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<String> CIDR_IPV4_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv4")
            .getter(getter(RevokedSecurityGroupRule::cidrIpv4))
            .setter(setter(Builder::cidrIpv4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv4")
                    .unmarshallLocationName("cidrIpv4").build()).build();

    private static final SdkField<String> CIDR_IPV6_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv6")
            .getter(getter(RevokedSecurityGroupRule::cidrIpv6))
            .setter(setter(Builder::cidrIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6")
                    .unmarshallLocationName("cidrIpv6").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(RevokedSecurityGroupRule::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("prefixListId").build()).build();

    private static final SdkField<String> REFERENCED_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReferencedGroupId")
            .getter(getter(RevokedSecurityGroupRule::referencedGroupId))
            .setter(setter(Builder::referencedGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencedGroupId")
                    .unmarshallLocationName("referencedGroupId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(RevokedSecurityGroupRule::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_RULE_ID_FIELD,
            GROUP_ID_FIELD, IS_EGRESS_FIELD, IP_PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD, CIDR_IPV4_FIELD, CIDR_IPV6_FIELD,
            PREFIX_LIST_ID_FIELD, REFERENCED_GROUP_ID_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String securityGroupRuleId;

    private final String groupId;

    private final Boolean isEgress;

    private final String ipProtocol;

    private final Integer fromPort;

    private final Integer toPort;

    private final String cidrIpv4;

    private final String cidrIpv6;

    private final String prefixListId;

    private final String referencedGroupId;

    private final String description;

    private RevokedSecurityGroupRule(BuilderImpl builder) {
        this.securityGroupRuleId = builder.securityGroupRuleId;
        this.groupId = builder.groupId;
        this.isEgress = builder.isEgress;
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.cidrIpv4 = builder.cidrIpv4;
        this.cidrIpv6 = builder.cidrIpv6;
        this.prefixListId = builder.prefixListId;
        this.referencedGroupId = builder.referencedGroupId;
        this.description = builder.description;
    }

    /**
     * <p>
     * A security group rule ID.
     * </p>
     * 
     * @return A security group rule ID.
     */
    public final String securityGroupRuleId() {
        return securityGroupRuleId;
    }

    /**
     * <p>
     * A security group ID.
     * </p>
     * 
     * @return A security group ID.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * Defines if a security group rule is an outbound rule.
     * </p>
     * 
     * @return Defines if a security group rule is an outbound rule.
     */
    public final Boolean isEgress() {
        return isEgress;
    }

    /**
     * <p>
     * The security group rule's protocol.
     * </p>
     * 
     * @return The security group rule's protocol.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * The 'from' port number of the security group rule.
     * </p>
     * 
     * @return The 'from' port number of the security group rule.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The 'to' port number of the security group rule.
     * </p>
     * 
     * @return The 'to' port number of the security group rule.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The IPv4 CIDR of the traffic source.
     * </p>
     * 
     * @return The IPv4 CIDR of the traffic source.
     */
    public final String cidrIpv4() {
        return cidrIpv4;
    }

    /**
     * <p>
     * The IPv6 CIDR of the traffic source.
     * </p>
     * 
     * @return The IPv6 CIDR of the traffic source.
     */
    public final String cidrIpv6() {
        return cidrIpv6;
    }

    /**
     * <p>
     * The ID of a prefix list that's the traffic source.
     * </p>
     * 
     * @return The ID of a prefix list that's the traffic source.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The ID of a referenced security group.
     * </p>
     * 
     * @return The ID of a referenced security group.
     */
    public final String referencedGroupId() {
        return referencedGroupId;
    }

    /**
     * <p>
     * A description of the revoked security group rule.
     * </p>
     * 
     * @return A description of the revoked security group rule.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(isEgress());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv4());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(referencedGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokedSecurityGroupRule)) {
            return false;
        }
        RevokedSecurityGroupRule other = (RevokedSecurityGroupRule) obj;
        return Objects.equals(securityGroupRuleId(), other.securityGroupRuleId()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(isEgress(), other.isEgress()) && Objects.equals(ipProtocol(), other.ipProtocol())
                && Objects.equals(fromPort(), other.fromPort()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(cidrIpv4(), other.cidrIpv4()) && Objects.equals(cidrIpv6(), other.cidrIpv6())
                && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(referencedGroupId(), other.referencedGroupId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokedSecurityGroupRule").add("SecurityGroupRuleId", securityGroupRuleId())
                .add("GroupId", groupId()).add("IsEgress", isEgress()).add("IpProtocol", ipProtocol())
                .add("FromPort", fromPort()).add("ToPort", toPort()).add("CidrIpv4", cidrIpv4()).add("CidrIpv6", cidrIpv6())
                .add("PrefixListId", prefixListId()).add("ReferencedGroupId", referencedGroupId())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupRuleId":
            return Optional.ofNullable(clazz.cast(securityGroupRuleId()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "IsEgress":
            return Optional.ofNullable(clazz.cast(isEgress()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "CidrIpv4":
            return Optional.ofNullable(clazz.cast(cidrIpv4()));
        case "CidrIpv6":
            return Optional.ofNullable(clazz.cast(cidrIpv6()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "ReferencedGroupId":
            return Optional.ofNullable(clazz.cast(referencedGroupId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityGroupRuleId", SECURITY_GROUP_RULE_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("IsEgress", IS_EGRESS_FIELD);
        map.put("IpProtocol", IP_PROTOCOL_FIELD);
        map.put("FromPort", FROM_PORT_FIELD);
        map.put("ToPort", TO_PORT_FIELD);
        map.put("CidrIpv4", CIDR_IPV4_FIELD);
        map.put("CidrIpv6", CIDR_IPV6_FIELD);
        map.put("PrefixListId", PREFIX_LIST_ID_FIELD);
        map.put("ReferencedGroupId", REFERENCED_GROUP_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokedSecurityGroupRule, T> g) {
        return obj -> g.apply((RevokedSecurityGroupRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RevokedSecurityGroupRule> {
        /**
         * <p>
         * A security group rule ID.
         * </p>
         * 
         * @param securityGroupRuleId
         *        A security group rule ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupRuleId(String securityGroupRuleId);

        /**
         * <p>
         * A security group ID.
         * </p>
         * 
         * @param groupId
         *        A security group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Defines if a security group rule is an outbound rule.
         * </p>
         * 
         * @param isEgress
         *        Defines if a security group rule is an outbound rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEgress(Boolean isEgress);

        /**
         * <p>
         * The security group rule's protocol.
         * </p>
         * 
         * @param ipProtocol
         *        The security group rule's protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * The 'from' port number of the security group rule.
         * </p>
         * 
         * @param fromPort
         *        The 'from' port number of the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The 'to' port number of the security group rule.
         * </p>
         * 
         * @param toPort
         *        The 'to' port number of the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The IPv4 CIDR of the traffic source.
         * </p>
         * 
         * @param cidrIpv4
         *        The IPv4 CIDR of the traffic source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv4(String cidrIpv4);

        /**
         * <p>
         * The IPv6 CIDR of the traffic source.
         * </p>
         * 
         * @param cidrIpv6
         *        The IPv6 CIDR of the traffic source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);

        /**
         * <p>
         * The ID of a prefix list that's the traffic source.
         * </p>
         * 
         * @param prefixListId
         *        The ID of a prefix list that's the traffic source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The ID of a referenced security group.
         * </p>
         * 
         * @param referencedGroupId
         *        The ID of a referenced security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedGroupId(String referencedGroupId);

        /**
         * <p>
         * A description of the revoked security group rule.
         * </p>
         * 
         * @param description
         *        A description of the revoked security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String securityGroupRuleId;

        private String groupId;

        private Boolean isEgress;

        private String ipProtocol;

        private Integer fromPort;

        private Integer toPort;

        private String cidrIpv4;

        private String cidrIpv6;

        private String prefixListId;

        private String referencedGroupId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokedSecurityGroupRule model) {
            securityGroupRuleId(model.securityGroupRuleId);
            groupId(model.groupId);
            isEgress(model.isEgress);
            ipProtocol(model.ipProtocol);
            fromPort(model.fromPort);
            toPort(model.toPort);
            cidrIpv4(model.cidrIpv4);
            cidrIpv6(model.cidrIpv6);
            prefixListId(model.prefixListId);
            referencedGroupId(model.referencedGroupId);
            description(model.description);
        }

        public final String getSecurityGroupRuleId() {
            return securityGroupRuleId;
        }

        public final void setSecurityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
        }

        @Override
        public final Builder securityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Boolean getIsEgress() {
            return isEgress;
        }

        public final void setIsEgress(Boolean isEgress) {
            this.isEgress = isEgress;
        }

        @Override
        public final Builder isEgress(Boolean isEgress) {
            this.isEgress = isEgress;
            return this;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final String getCidrIpv4() {
            return cidrIpv4;
        }

        public final void setCidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
        }

        @Override
        public final Builder cidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
            return this;
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getReferencedGroupId() {
            return referencedGroupId;
        }

        public final void setReferencedGroupId(String referencedGroupId) {
            this.referencedGroupId = referencedGroupId;
        }

        @Override
        public final Builder referencedGroupId(String referencedGroupId) {
            this.referencedGroupId = referencedGroupId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public RevokedSecurityGroupRule build() {
            return new RevokedSecurityGroupRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
