/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionByoipCidrRequest extends Ec2Request implements
        ToCopyableBuilder<ProvisionByoipCidrRequest.Builder, ProvisionByoipCidrRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(ProvisionByoipCidrRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<CidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField
            .<CidrAuthorizationContext> builder(MarshallingType.SDK_POJO)
            .memberName("CidrAuthorizationContext")
            .getter(getter(ProvisionByoipCidrRequest::cidrAuthorizationContext))
            .setter(setter(Builder::cidrAuthorizationContext))
            .constructor(CidrAuthorizationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext")
                    .unmarshallLocationName("CidrAuthorizationContext").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ADVERTISABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAdvertisable")
            .getter(getter(ProvisionByoipCidrRequest::publiclyAdvertisable))
            .setter(setter(Builder::publiclyAdvertisable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAdvertisable")
                    .unmarshallLocationName("PubliclyAdvertisable").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ProvisionByoipCidrRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ProvisionByoipCidrRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<TagSpecification>> POOL_TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("PoolTagSpecifications")
            .getter(getter(ProvisionByoipCidrRequest::poolTagSpecifications))
            .setter(setter(Builder::poolTagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolTagSpecification")
                    .unmarshallLocationName("PoolTagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> MULTI_REGION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiRegion")
            .getter(getter(ProvisionByoipCidrRequest::multiRegion))
            .setter(setter(Builder::multiRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegion")
                    .unmarshallLocationName("MultiRegion").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup")
            .getter(getter(ProvisionByoipCidrRequest::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("NetworkBorderGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            CIDR_AUTHORIZATION_CONTEXT_FIELD, PUBLICLY_ADVERTISABLE_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD,
            POOL_TAG_SPECIFICATIONS_FIELD, MULTI_REGION_FIELD, NETWORK_BORDER_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cidr;

    private final CidrAuthorizationContext cidrAuthorizationContext;

    private final Boolean publiclyAdvertisable;

    private final String description;

    private final Boolean dryRun;

    private final List<TagSpecification> poolTagSpecifications;

    private final Boolean multiRegion;

    private final String networkBorderGroup;

    private ProvisionByoipCidrRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
        this.publiclyAdvertisable = builder.publiclyAdvertisable;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.poolTagSpecifications = builder.poolTagSpecifications;
        this.multiRegion = builder.multiRegion;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    /**
     * <p>
     * The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can specify is
     * /24. The most specific IPv6 address range that you can bring is /48 for CIDRs that are publicly advertisable and
     * /56 for CIDRs that are not publicly advertisable. The address range cannot overlap with another address range
     * that you've brought to this or another Region.
     * </p>
     * 
     * @return The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can
     *         specify is /24. The most specific IPv6 address range that you can bring is /48 for CIDRs that are
     *         publicly advertisable and /56 for CIDRs that are not publicly advertisable. The address range cannot
     *         overlap with another address range that you've brought to this or another Region.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
     * BYOIP.
     * </p>
     * 
     * @return A signed document that proves that you are authorized to bring the specified IP address range to Amazon
     *         using BYOIP.
     */
    public final CidrAuthorizationContext cidrAuthorizationContext() {
        return cidrAuthorizationContext;
    }

    /**
     * <p>
     * (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.
     * </p>
     * <p>
     * Default: true
     * </p>
     * 
     * @return (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.</p>
     *         <p>
     *         Default: true
     */
    public final Boolean publiclyAdvertisable() {
        return publiclyAdvertisable;
    }

    /**
     * <p>
     * A description for the address range and the address pool.
     * </p>
     * 
     * @return A description for the address range and the address pool.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the PoolTagSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPoolTagSpecifications() {
        return poolTagSpecifications != null && !(poolTagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the address pool.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPoolTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the address pool.
     */
    public final List<TagSpecification> poolTagSpecifications() {
        return poolTagSpecifications;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public final Boolean multiRegion() {
        return multiRegion;
    }

    /**
     * <p>
     * If you have <a href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local Zones</a>
     * enabled, you can choose a network border group for Local Zones when you provision and advertise a BYOIPv4 CIDR.
     * Choose the network border group carefully as the EIP and the Amazon Web Services resource it is associated with
     * must reside in the same network border group.
     * </p>
     * <p>
     * You can provision BYOIP address ranges to and advertise them in the following Local Zone network border groups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * us-east-1-dfw-2
     * </p>
     * </li>
     * <li>
     * <p>
     * us-west-2-lax-1
     * </p>
     * </li>
     * <li>
     * <p>
     * us-west-2-phx-2
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
     * </p>
     * </note>
     * 
     * @return If you have <a href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local
     *         Zones</a> enabled, you can choose a network border group for Local Zones when you provision and advertise
     *         a BYOIPv4 CIDR. Choose the network border group carefully as the EIP and the Amazon Web Services resource
     *         it is associated with must reside in the same network border group.</p>
     *         <p>
     *         You can provision BYOIP address ranges to and advertise them in the following Local Zone network border
     *         groups:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         us-east-1-dfw-2
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         us-west-2-lax-1
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         us-west-2-phx-2
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
     *         </p>
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(cidrAuthorizationContext());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAdvertisable());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasPoolTagSpecifications() ? poolTagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiRegion());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionByoipCidrRequest)) {
            return false;
        }
        ProvisionByoipCidrRequest other = (ProvisionByoipCidrRequest) obj;
        return Objects.equals(cidr(), other.cidr())
                && Objects.equals(cidrAuthorizationContext(), other.cidrAuthorizationContext())
                && Objects.equals(publiclyAdvertisable(), other.publiclyAdvertisable())
                && Objects.equals(description(), other.description()) && Objects.equals(dryRun(), other.dryRun())
                && hasPoolTagSpecifications() == other.hasPoolTagSpecifications()
                && Objects.equals(poolTagSpecifications(), other.poolTagSpecifications())
                && Objects.equals(multiRegion(), other.multiRegion())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionByoipCidrRequest").add("Cidr", cidr())
                .add("CidrAuthorizationContext", cidrAuthorizationContext()).add("PubliclyAdvertisable", publiclyAdvertisable())
                .add("Description", description()).add("DryRun", dryRun())
                .add("PoolTagSpecifications", hasPoolTagSpecifications() ? poolTagSpecifications() : null)
                .add("MultiRegion", multiRegion()).add("NetworkBorderGroup", networkBorderGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "CidrAuthorizationContext":
            return Optional.ofNullable(clazz.cast(cidrAuthorizationContext()));
        case "PubliclyAdvertisable":
            return Optional.ofNullable(clazz.cast(publiclyAdvertisable()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "PoolTagSpecifications":
            return Optional.ofNullable(clazz.cast(poolTagSpecifications()));
        case "MultiRegion":
            return Optional.ofNullable(clazz.cast(multiRegion()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cidr", CIDR_FIELD);
        map.put("CidrAuthorizationContext", CIDR_AUTHORIZATION_CONTEXT_FIELD);
        map.put("PubliclyAdvertisable", PUBLICLY_ADVERTISABLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("PoolTagSpecification", POOL_TAG_SPECIFICATIONS_FIELD);
        map.put("MultiRegion", MULTI_REGION_FIELD);
        map.put("NetworkBorderGroup", NETWORK_BORDER_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisionByoipCidrRequest, T> g) {
        return obj -> g.apply((ProvisionByoipCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionByoipCidrRequest> {
        /**
         * <p>
         * The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can specify
         * is /24. The most specific IPv6 address range that you can bring is /48 for CIDRs that are publicly
         * advertisable and /56 for CIDRs that are not publicly advertisable. The address range cannot overlap with
         * another address range that you've brought to this or another Region.
         * </p>
         * 
         * @param cidr
         *        The public IPv4 or IPv6 address range, in CIDR notation. The most specific IPv4 prefix that you can
         *        specify is /24. The most specific IPv6 address range that you can bring is /48 for CIDRs that are
         *        publicly advertisable and /56 for CIDRs that are not publicly advertisable. The address range cannot
         *        overlap with another address range that you've brought to this or another Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
         * BYOIP.
         * </p>
         * 
         * @param cidrAuthorizationContext
         *        A signed document that proves that you are authorized to bring the specified IP address range to
         *        Amazon using BYOIP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring the specified IP address range to Amazon using
         * BYOIP.
         * </p>
         * This is a convenience method that creates an instance of the {@link CidrAuthorizationContext.Builder}
         * avoiding the need to create one manually via {@link CidrAuthorizationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CidrAuthorizationContext.Builder#build()} is called immediately
         * and its result is passed to {@link #cidrAuthorizationContext(CidrAuthorizationContext)}.
         * 
         * @param cidrAuthorizationContext
         *        a consumer that will call methods on {@link CidrAuthorizationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrAuthorizationContext(CidrAuthorizationContext)
         */
        default Builder cidrAuthorizationContext(Consumer<CidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return cidrAuthorizationContext(CidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext).build());
        }

        /**
         * <p>
         * (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.
         * </p>
         * <p>
         * Default: true
         * </p>
         * 
         * @param publiclyAdvertisable
         *        (IPv6 only) Indicate whether the address range will be publicly advertised to the internet.</p>
         *        <p>
         *        Default: true
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAdvertisable(Boolean publiclyAdvertisable);

        /**
         * <p>
         * A description for the address range and the address pool.
         * </p>
         * 
         * @param description
         *        A description for the address range and the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The tags to apply to the address pool.
         * </p>
         * 
         * @param poolTagSpecifications
         *        The tags to apply to the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolTagSpecifications(Collection<TagSpecification> poolTagSpecifications);

        /**
         * <p>
         * The tags to apply to the address pool.
         * </p>
         * 
         * @param poolTagSpecifications
         *        The tags to apply to the address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder poolTagSpecifications(TagSpecification... poolTagSpecifications);

        /**
         * <p>
         * The tags to apply to the address pool.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #poolTagSpecifications(List<TagSpecification>)}.
         * 
         * @param poolTagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #poolTagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder poolTagSpecifications(Consumer<TagSpecification.Builder>... poolTagSpecifications);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param multiRegion
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegion(Boolean multiRegion);

        /**
         * <p>
         * If you have <a href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local
         * Zones</a> enabled, you can choose a network border group for Local Zones when you provision and advertise a
         * BYOIPv4 CIDR. Choose the network border group carefully as the EIP and the Amazon Web Services resource it is
         * associated with must reside in the same network border group.
         * </p>
         * <p>
         * You can provision BYOIP address ranges to and advertise them in the following Local Zone network border
         * groups:
         * </p>
         * <ul>
         * <li>
         * <p>
         * us-east-1-dfw-2
         * </p>
         * </li>
         * <li>
         * <p>
         * us-west-2-lax-1
         * </p>
         * </li>
         * <li>
         * <p>
         * us-west-2-phx-2
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
         * </p>
         * </note>
         * 
         * @param networkBorderGroup
         *        If you have <a
         *        href="https://docs.aws.amazon.com/local-zones/latest/ug/how-local-zones-work.html">Local Zones</a>
         *        enabled, you can choose a network border group for Local Zones when you provision and advertise a
         *        BYOIPv4 CIDR. Choose the network border group carefully as the EIP and the Amazon Web Services
         *        resource it is associated with must reside in the same network border group.</p>
         *        <p>
         *        You can provision BYOIP address ranges to and advertise them in the following Local Zone network
         *        border groups:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        us-east-1-dfw-2
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        us-west-2-lax-1
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        us-west-2-phx-2
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        You cannot provision or advertise BYOIPv6 address ranges in Local Zones at this time.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String cidr;

        private CidrAuthorizationContext cidrAuthorizationContext;

        private Boolean publiclyAdvertisable;

        private String description;

        private Boolean dryRun;

        private List<TagSpecification> poolTagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiRegion;

        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionByoipCidrRequest model) {
            super(model);
            cidr(model.cidr);
            cidrAuthorizationContext(model.cidrAuthorizationContext);
            publiclyAdvertisable(model.publiclyAdvertisable);
            description(model.description);
            dryRun(model.dryRun);
            poolTagSpecifications(model.poolTagSpecifications);
            multiRegion(model.multiRegion);
            networkBorderGroup(model.networkBorderGroup);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final CidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return cidrAuthorizationContext != null ? cidrAuthorizationContext.toBuilder() : null;
        }

        public final void setCidrAuthorizationContext(CidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        @Override
        public final Builder cidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        public final Boolean getPubliclyAdvertisable() {
            return publiclyAdvertisable;
        }

        public final void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
        }

        @Override
        public final Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getPoolTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.poolTagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPoolTagSpecifications(Collection<TagSpecification.BuilderImpl> poolTagSpecifications) {
            this.poolTagSpecifications = TagSpecificationListCopier.copyFromBuilder(poolTagSpecifications);
        }

        @Override
        public final Builder poolTagSpecifications(Collection<TagSpecification> poolTagSpecifications) {
            this.poolTagSpecifications = TagSpecificationListCopier.copy(poolTagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolTagSpecifications(TagSpecification... poolTagSpecifications) {
            poolTagSpecifications(Arrays.asList(poolTagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder poolTagSpecifications(Consumer<TagSpecification.Builder>... poolTagSpecifications) {
            poolTagSpecifications(Stream.of(poolTagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegion() {
            return multiRegion;
        }

        public final void setMultiRegion(Boolean multiRegion) {
            this.multiRegion = multiRegion;
        }

        @Override
        public final Builder multiRegion(Boolean multiRegion) {
            this.multiRegion = multiRegion;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionByoipCidrRequest build() {
            return new ProvisionByoipCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
