/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableAwsNetworkPerformanceMetricSubscriptionResponse extends Ec2Response
        implements
        ToCopyableBuilder<EnableAwsNetworkPerformanceMetricSubscriptionResponse.Builder, EnableAwsNetworkPerformanceMetricSubscriptionResponse> {
    private static final SdkField<Boolean> OUTPUT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Output")
            .getter(getter(EnableAwsNetworkPerformanceMetricSubscriptionResponse::output))
            .setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output")
                    .unmarshallLocationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean output;

    private EnableAwsNetworkPerformanceMetricSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.output = builder.output;
    }

    /**
     * <p>
     * Indicates whether the subscribe action was successful.
     * </p>
     * 
     * @return Indicates whether the subscribe action was successful.
     */
    public final Boolean output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAwsNetworkPerformanceMetricSubscriptionResponse)) {
            return false;
        }
        EnableAwsNetworkPerformanceMetricSubscriptionResponse other = (EnableAwsNetworkPerformanceMetricSubscriptionResponse) obj;
        return Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableAwsNetworkPerformanceMetricSubscriptionResponse").add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableAwsNetworkPerformanceMetricSubscriptionResponse, T> g) {
        return obj -> g.apply((EnableAwsNetworkPerformanceMetricSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableAwsNetworkPerformanceMetricSubscriptionResponse> {
        /**
         * <p>
         * Indicates whether the subscribe action was successful.
         * </p>
         * 
         * @param output
         *        Indicates whether the subscribe action was successful.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(Boolean output);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean output;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAwsNetworkPerformanceMetricSubscriptionResponse model) {
            super(model);
            output(model.output);
        }

        public final Boolean getOutput() {
            return output;
        }

        public final void setOutput(Boolean output) {
            this.output = output;
        }

        @Override
        public final Builder output(Boolean output) {
            this.output = output;
            return this;
        }

        @Override
        public EnableAwsNetworkPerformanceMetricSubscriptionResponse build() {
            return new EnableAwsNetworkPerformanceMetricSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
