/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class UDPMirror {
    public static void main(String[] args) throws IOException {
        if (args.length != 0) {
            int c = 0;
            boolean verbose = false;
            if (args[c].equals("-v")) {
                verbose = true;
            }
            int n = ++c;
            ++c;
            int listeningOnPort = Integer.valueOf(args[n]);
            byte[] buf = new byte[65536];
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                DatagramSocket udpSocket = new DatagramSocket(listeningOnPort);
                try {
                    DatagramPacket received = new DatagramPacket(buf, buf.length);
                    DatagramSocket[] sendingSockets = new DatagramSocket[(args.length - 1) / 2];
                    DatagramPacket[] mirroredPackets = new DatagramPacket[(args.length - 1) / 2];
                    while (c < args.length - 1) {
                        sendingSockets[(c - 1) / 2] = new DatagramSocket();
                        mirroredPackets[(c - 1) / 2] = new DatagramPacket(buf, buf.length, InetAddress.getByName(args[c]), Integer.valueOf(args[c + 1]));
                        c += 2;
                    }
                    block5: while (true) {
                        udpSocket.receive(received);
                        if (verbose) {
                            String packetAsString = new String(received.getData(), received.getOffset(), received.getLength()).trim();
                            System.out.println(packetAsString);
                        }
                        int i = 0;
                        while (true) {
                            if (i >= mirroredPackets.length) continue block5;
                            mirroredPackets[i].setLength(received.getLength());
                            sendingSockets[i].send(mirroredPackets[i]);
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (udpSocket != null) {
                        udpSocket.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        UDPMirror.usage();
    }

    private static void usage() {
        System.out.println("Usage: java " + UDPMirror.class.getName() + " [-v] <listeningport> hostname1 port1 [hostname2 port2]*");
        System.out.println("  -v\tPrint packets received to stdout");
    }
}

