/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.dom.client.Document;
import org.moxieapps.gwt.highcharts.client.Axis;
import org.moxieapps.gwt.highcharts.client.Color;
import org.moxieapps.gwt.highcharts.client.Configurable;
import org.moxieapps.gwt.highcharts.client.labels.PlotLineLabel;

public class PlotLine
extends Configurable<PlotLine> {
    private Axis axis;
    private String id;

    PlotLine(Axis axis) {
        this.axis = axis;
        this.id = Document.get().createUniqueId();
        this.setOption("id", this.id);
    }

    public PlotLine setColor(String color) {
        return (PlotLine)this.setOption("color", color);
    }

    public PlotLine setColor(Color color) {
        return (PlotLine)this.setOption("color", color != null ? color.getOptionValue() : null);
    }

    public PlotLine setDashStyle(DashStyle dashStyle) {
        return (PlotLine)this.setOption("dashStyle", dashStyle != null ? dashStyle.toString() : null);
    }

    public PlotLine setLabel(PlotLineLabel plotLineLabel) {
        return (PlotLine)this.setOption("label", plotLineLabel != null ? plotLineLabel.getOptions() : null);
    }

    public PlotLine setValue(Number value) {
        return (PlotLine)this.setOption("value", value);
    }

    public PlotLine setWidth(Number width) {
        return (PlotLine)this.setOption("width", width);
    }

    public PlotLine setZIndex(Number zIndex) {
        return (PlotLine)this.setOption("zIndex", zIndex);
    }

    String getId() {
        return this.id;
    }

    public static enum DashStyle {
        SOLID("Solid"),
        SHORT_DASH("ShortDash"),
        SHORT_DOT("ShortDot"),
        SHORT_DASH_DOT("ShortDashDot"),
        SHORT_DASH_DOT_DOT("ShortDashDotDot"),
        DOT("Dot"),
        DASH("Dash"),
        LONG_DASH("LongDash"),
        DASH_DOT("DashDot"),
        LONG_DASH_DOT("LongDashDot"),
        LONG_DASH_DOT_DOT("LongDashDotDot");

        private final String optionValue;

        private DashStyle(String optionValue) {
            this.optionValue = optionValue;
        }

        public String toString() {
            return this.optionValue;
        }
    }
}

