/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components.management;

import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.management.AggregationProcessorDefinitionRegistry;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.util.ClassUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AggregationProcessorDefinitionManager
implements AggregationProcessorDefinitionRegistry {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<Class<?>, Map<String, AggregationProcessorDefinition<?, ?>>> definitionsMappedByExtractedTypeAndMessageKey = new HashMap();

    @Override
    public Iterable<AggregationProcessorDefinition<?, ?>> getAll() {
        HashSet allDefinitions = new HashSet();
        for (Map<String, AggregationProcessorDefinition<?, ?>> definitionsForType : this.definitionsMappedByExtractedTypeAndMessageKey.values()) {
            allDefinitions.addAll(definitionsForType.values());
        }
        return allDefinitions;
    }

    @Override
    public <ExtractedType> AggregationProcessorDefinition<ExtractedType, ?> get(Class<ExtractedType> extractedType, String aggregationNameMessageKey) {
        AggregationProcessorDefinition<?, ?> definition = null;
        Map<String, AggregationProcessorDefinition<?, ?>> definitionsForType = this.definitionsMappedByExtractedTypeAndMessageKey.get(extractedType);
        if (definitionsForType != null) {
            definition = definitionsForType.get(aggregationNameMessageKey);
        }
        return definition;
    }

    @Override
    public <ExtractedType> Iterable<AggregationProcessorDefinition<? super ExtractedType, ?>> getByExtractedType(Class<ExtractedType> extractedType) {
        HashSet definitions = new HashSet();
        Class<?> cleanExtractedType = ClassUtils.primitiveTypeToWrapperClass(extractedType);
        Collection<Class<?>> typesToGet = ClassUtils.getSupertypesOf(cleanExtractedType);
        typesToGet.add(cleanExtractedType);
        typesToGet.add(Object.class);
        for (Class<?> type : typesToGet) {
            definitions.addAll(this.getByUnspecificTypeAsSpecificType(type));
        }
        return definitions;
    }

    private <ExtractedType> Collection<AggregationProcessorDefinition<? super ExtractedType, ?>> getByUnspecificTypeAsSpecificType(Class<?> extractedType) {
        HashSet definitions = new HashSet();
        if (this.definitionsMappedByExtractedTypeAndMessageKey.containsKey(extractedType)) {
            for (AggregationProcessorDefinition<?, ?> definition : this.definitionsMappedByExtractedTypeAndMessageKey.get(extractedType).values()) {
                definitions.add(definition);
            }
        }
        return definitions;
    }

    @Override
    public <ExtractedType, ResultType> AggregationProcessorDefinition<ExtractedType, ResultType> getForDTO(AggregationProcessorDefinitionDTO aggregatorDefinitionDTO, ClassLoader classLoader) {
        AggregationProcessorDefinition<?, ?> aggregatorDefinition = null;
        if (aggregatorDefinitionDTO != null) {
            try {
                Class<?> extractedType = ClassUtils.getClassForName(aggregatorDefinitionDTO.getExtractedTypeName(), true, classLoader);
                aggregatorDefinition = this.get(extractedType, aggregatorDefinitionDTO.getMessageKey());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Couldn't get classes for the aggregator definition DTO " + aggregatorDefinitionDTO, e);
            }
            if (aggregatorDefinition == null) {
                this.logger.log(Level.WARNING, "No aggregator definition found for the DTO: " + aggregatorDefinitionDTO);
            }
        }
        return aggregatorDefinition;
    }

    @Override
    public boolean register(AggregationProcessorDefinition<?, ?> aggregationProcessorDefinition) {
        AggregationProcessorDefinition<?, ?> previousDefinition;
        if (this.get(aggregationProcessorDefinition.getExtractedType(), aggregationProcessorDefinition.getAggregationNameMessageKey()) != null) {
            this.logger.info("Can't register the aggregation processor definition " + aggregationProcessorDefinition + ", because there's allready a definition registered for the extracted type " + aggregationProcessorDefinition.getExtractedType().getName() + " and the message key " + aggregationProcessorDefinition.getAggregationNameMessageKey());
            return false;
        }
        Class<?> extractedType = aggregationProcessorDefinition.getExtractedType();
        if (!this.definitionsMappedByExtractedTypeAndMessageKey.containsKey(extractedType)) {
            this.definitionsMappedByExtractedTypeAndMessageKey.put(extractedType, new HashMap());
        }
        if ((previousDefinition = this.definitionsMappedByExtractedTypeAndMessageKey.get(extractedType).put(aggregationProcessorDefinition.getAggregationNameMessageKey(), aggregationProcessorDefinition)) == null) {
            this.logger.info("Registering the aggregation processor definition " + aggregationProcessorDefinition + " for the extracted type " + aggregationProcessorDefinition.getExtractedType().getName() + " and the message key " + aggregationProcessorDefinition.getAggregationNameMessageKey());
        } else {
            this.logger.info("Registering the aggregation processor definition " + aggregationProcessorDefinition + " for the extracted type " + aggregationProcessorDefinition.getExtractedType().getName() + " and the message key " + aggregationProcessorDefinition.getAggregationNameMessageKey() + " replacing " + previousDefinition);
        }
        return true;
    }

    @Override
    public boolean unregister(AggregationProcessorDefinition<?, ?> aggregationProcessorDefinition) {
        boolean changed = false;
        Class<?> extractedType = aggregationProcessorDefinition.getExtractedType();
        if (this.definitionsMappedByExtractedTypeAndMessageKey.containsKey(extractedType) && this.definitionsMappedByExtractedTypeAndMessageKey.get(extractedType).remove(aggregationProcessorDefinition.getAggregationNameMessageKey()) != null) {
            changed = true;
        }
        if (changed) {
            this.logger.info("Unregistering the aggregation processor definition " + aggregationProcessorDefinition + " for the extracted type " + aggregationProcessorDefinition.getExtractedType().getName() + " and the message key " + aggregationProcessorDefinition.getAggregationNameMessageKey());
        } else {
            this.logger.info("Can't unregister the aggregation processor definition " + aggregationProcessorDefinition + ", because there's no definition registered for the extracted type " + aggregationProcessorDefinition.getExtractedType().getName() + " and the message key " + aggregationProcessorDefinition.getAggregationNameMessageKey());
        }
        return changed;
    }
}

