/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.components;

import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.components.DataRetrieverChainBuilder;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.impl.components.SimpleDataRetrieverChainBuilder;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;

public class SimpleDataRetrieverChainDefinition<DataSourceType, DataType>
implements DataRetrieverChainDefinition<DataSourceType, DataType> {
    private final Class<DataSourceType> dataSourceType;
    private final Class<DataType> retrievedDataType;
    private final List<DataRetrieverLevel<?, ?>> dataRetrieverTypesWithInformation;
    private final String nameMessageKey;
    protected boolean isComplete;

    public SimpleDataRetrieverChainDefinition(Class<DataSourceType> dataSourceType, Class<DataType> retrievedDataType, String nameMessageKey) {
        this.dataSourceType = dataSourceType;
        this.retrievedDataType = retrievedDataType;
        this.dataRetrieverTypesWithInformation = new ArrayList();
        this.nameMessageKey = nameMessageKey;
        this.isComplete = false;
    }

    public SimpleDataRetrieverChainDefinition(DataRetrieverChainDefinition<DataSourceType, ?> dataRetrieverChainDefinition, Class<DataType> retrievedDataType, String nameMessageKey) {
        this(dataRetrieverChainDefinition.getDataSourceType(), retrievedDataType, nameMessageKey);
        this.dataRetrieverTypesWithInformation.addAll(dataRetrieverChainDefinition.getDataRetrieverLevels());
    }

    @Override
    public String getLocalizedName(Locale locale, ResourceBundleStringMessages stringMessages) {
        return stringMessages.get(locale, this.nameMessageKey);
    }

    @Override
    public Class<DataSourceType> getDataSourceType() {
        return this.dataSourceType;
    }

    @Override
    public Class<DataType> getRetrievedDataType() {
        return this.retrievedDataType;
    }

    @Override
    public void startAndEndWith(Class<? extends Processor<DataSourceType, DataType>> retrieverType, Class<DataType> retrievedDataType, String retrievedDataTypeMessageKey) {
        this.startAndEndWith(retrieverType, retrievedDataType, null, null, retrievedDataTypeMessageKey);
    }

    @Override
    public <SettingsType extends SerializableSettings> void startAndEndWith(Class<? extends Processor<DataSourceType, DataType>> retrieverType, Class<DataType> retrievedDataType, Class<SettingsType> settingsType, SettingsType defaultSettings, String retrievedDataTypeMessageKey) {
        this.startWith(retrieverType, retrievedDataType, settingsType, defaultSettings, retrievedDataTypeMessageKey);
        this.isComplete = true;
    }

    @Override
    public <ResultType> void startWith(Class<? extends Processor<DataSourceType, ResultType>> retrieverType, Class<ResultType> retrievedDataType, String retrievedDataTypeMessageKey) {
        this.startWith(retrieverType, retrievedDataType, null, null, retrievedDataTypeMessageKey);
    }

    @Override
    public <ResultType, SettingsType extends SerializableSettings> void startWith(Class<? extends Processor<DataSourceType, ResultType>> retrieverType, Class<ResultType> retrievedDataType, Class<SettingsType> settingsType, SettingsType defaultSettings, String retrievedDataTypeMessageKey) {
        if (this.isInitialized()) {
            throw new IllegalStateException("This retriever chain definition already has been started with '" + this.dataRetrieverTypesWithInformation.get(0).getRetrieverType().getSimpleName() + "'");
        }
        this.checkThatRetrieverHasUsableConstructor(retrieverType, settingsType);
        if (settingsType != null && defaultSettings == null) {
            throw new NullPointerException("No default settings have been given");
        }
        DataRetrieverLevel retrieverTypeWithInformation = new DataRetrieverLevel(this.dataRetrieverTypesWithInformation.size(), retrieverType, retrievedDataType, settingsType, retrievedDataTypeMessageKey, defaultSettings);
        this.dataRetrieverTypesWithInformation.add(retrieverTypeWithInformation);
    }

    private boolean isInitialized() {
        return !this.dataRetrieverTypesWithInformation.isEmpty();
    }

    @Override
    public <NextInputType, NextResultType, PreviousInputType, PreviousResultType extends NextInputType> void addAfter(Class<? extends Processor<PreviousInputType, PreviousResultType>> lastAddedRetrieverType, Class<? extends Processor<NextInputType, NextResultType>> nextRetrieverType, Class<NextResultType> retrievedDataType, String retrievedDataTypeMessageKey) {
        this.addAfter(lastAddedRetrieverType, nextRetrieverType, retrievedDataType, null, null, retrievedDataTypeMessageKey);
    }

    @Override
    public <NextInputType, NextResultType, PreviousInputType, PreviousResultType extends NextInputType, SettingsType extends SerializableSettings> void addAfter(Class<? extends Processor<PreviousInputType, PreviousResultType>> lastAddedRetrieverType, Class<? extends Processor<NextInputType, NextResultType>> nextRetrieverType, Class<NextResultType> retrievedDataType, Class<SettingsType> settingsType, SettingsType defaultSettings, String retrievedDataTypeMessageKey) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("This retriever chain definition hasn't been started yet");
        }
        if (this.isComplete) {
            throw new IllegalStateException("This retriever chain definition is already complete");
        }
        DataRetrieverLevel<?, ?> dataRetrieverTypeWithInformation = this.dataRetrieverTypesWithInformation.get(this.dataRetrieverTypesWithInformation.size() - 1);
        Class<Processor<?, ?>> lastRetrieverInList = dataRetrieverTypeWithInformation.getRetrieverType();
        if (!lastRetrieverInList.equals(lastAddedRetrieverType)) {
            throw new IllegalArgumentException("The given previousRetrieverType '" + lastAddedRetrieverType.getSimpleName() + "' doesn't match the last retriever type in the chain '" + lastRetrieverInList.getSimpleName() + "'");
        }
        this.checkThatRetrieverHasUsableConstructor(nextRetrieverType, settingsType);
        if (settingsType != null && defaultSettings == null) {
            throw new NullPointerException("No default settings have been given");
        }
        DataRetrieverLevel retrieverTypeWithInformation = new DataRetrieverLevel(this.dataRetrieverTypesWithInformation.size(), nextRetrieverType, retrievedDataType, settingsType, retrievedDataTypeMessageKey, defaultSettings);
        this.dataRetrieverTypesWithInformation.add(retrieverTypeWithInformation);
    }

    private <InputType, ResultType, SettingsType> void checkThatRetrieverHasUsableConstructor(Class<? extends Processor<InputType, ResultType>> retrieverType, Class<SettingsType> settingsType) {
        try {
            if (settingsType == null) {
                retrieverType.getConstructor(ExecutorService.class, Collection.class, Integer.TYPE, String.class);
            } else {
                retrieverType.getConstructor(ExecutorService.class, Collection.class, settingsType, Integer.TYPE, String.class);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Couldn't get an usable constructor from the given nextRetrieverType '" + retrieverType.getSimpleName() + "'", e);
        }
    }

    @Override
    public <NextInputType, PreviousInputType, PreviousResultType extends NextInputType> void endWith(Class<? extends Processor<PreviousInputType, PreviousResultType>> lastAddedRetrieverType, Class<? extends Processor<NextInputType, DataType>> lastRetrieverType, Class<DataType> retrievedDataType, String retrievedDataTypeMessageKey) {
        this.endWith(lastAddedRetrieverType, lastRetrieverType, retrievedDataType, null, null, retrievedDataTypeMessageKey);
    }

    @Override
    public <NextInputType, PreviousInputType, PreviousResultType extends NextInputType, SettingsType extends SerializableSettings> void endWith(Class<? extends Processor<PreviousInputType, PreviousResultType>> lastAddedRetrieverType, Class<? extends Processor<NextInputType, DataType>> lastRetrieverType, Class<DataType> retrievedDataType, Class<SettingsType> settingsType, SettingsType defaultSettings, String retrievedDataTypeMessageKey) {
        this.addAfter(lastAddedRetrieverType, lastRetrieverType, retrievedDataType, settingsType, defaultSettings, retrievedDataTypeMessageKey);
        this.isComplete = true;
    }

    @Override
    public List<? extends DataRetrieverLevel<?, ?>> getDataRetrieverLevels() {
        return this.dataRetrieverTypesWithInformation;
    }

    @Override
    public DataRetrieverLevel<?, ?> getDataRetrieverLevel(int levelIndex) {
        if (levelIndex < 0 || levelIndex >= this.getDataRetrieverLevels().size()) {
            return null;
        }
        return this.getDataRetrieverLevels().get(levelIndex);
    }

    @Override
    public DataRetrieverChainBuilder<DataSourceType> startBuilding(ExecutorService executor) {
        if (!this.isComplete) {
            throw new IllegalStateException("This retriever chain definition hasn't been completed yet");
        }
        return new SimpleDataRetrieverChainBuilder(executor, this.dataRetrieverTypesWithInformation);
    }

    public String toString() {
        return String.valueOf(this.getDataSourceType().getSimpleName()) + " -> " + this.getRetrievedDataType().getSimpleName() + "[messageKey: " + this.nameMessageKey + ", isComplete: " + this.isComplete + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataRetrieverTypesWithInformation == null ? 0 : this.dataRetrieverTypesWithInformation.hashCode());
        result = 31 * result + (this.dataSourceType == null ? 0 : this.dataSourceType.hashCode());
        result = 31 * result + (this.retrievedDataType == null ? 0 : this.retrievedDataType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleDataRetrieverChainDefinition other = (SimpleDataRetrieverChainDefinition)obj;
        if (this.dataRetrieverTypesWithInformation == null ? other.dataRetrieverTypesWithInformation != null : !this.dataRetrieverTypesWithInformation.equals(other.dataRetrieverTypesWithInformation)) {
            return false;
        }
        if (this.dataSourceType == null ? other.dataSourceType != null : !this.dataSourceType.equals(other.dataSourceType)) {
            return false;
        }
        return !(this.retrievedDataType == null ? other.retrievedDataType != null : !this.retrievedDataType.equals(other.retrievedDataType));
    }
}

