/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.session.ClientSession;
import com.sap.sse.common.Duration;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.MongoProcess;
import com.sap.sse.landscape.mongodb.MongoReplicaSet;
import com.sap.sse.landscape.mongodb.impl.DatabaseImpl;
import com.sap.sse.landscape.mongodb.impl.SimpleMongoEndpointImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public interface MongoEndpoint {
    public static MongoEndpoint of(String hostname, int port) {
        return new SimpleMongoEndpointImpl(hostname, port);
    }

    public static MongoEndpoint of(String hostname, int port, String replicaSetName) {
        return new SimpleMongoEndpointImpl(hostname, port, replicaSetName);
    }

    public URI getURI(Optional<Database> var1) throws URISyntaxException;

    public URI getURI(Optional<Database> var1, Optional<Duration> var2) throws URISyntaxException;

    default public URI getURI(Optional<Database> optionalDb, String hostname, int port, Optional<String> replicaSetName) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("mongodb://");
        sb.append(hostname);
        sb.append(":");
        sb.append(port);
        sb.append("/");
        optionalDb.ifPresent(db -> {
            StringBuilder stringBuilder2 = sb.append(db.getName());
        });
        replicaSetName.ifPresent(rsName -> this.appendReplicaSetParametersToURI((String)rsName, sb));
        return new URI(sb.toString());
    }

    default public void appendReplicaSetParametersToURI(String replicaSetName, StringBuilder uriStringBuilder) {
        uriStringBuilder.append("?replicaSet=");
        uriStringBuilder.append(replicaSetName);
        uriStringBuilder.append("&retryWrites=true&readPreference=nearest");
    }

    public Iterable<MongoDatabase> getMongoDatabases() throws URISyntaxException;

    public MongoDatabase getMongoDatabase(String var1) throws URISyntaxException;

    public MongoDatabase importDatabase(MongoDatabase var1) throws URISyntaxException;

    public boolean isInReplicaSet() throws URISyntaxException;

    default public boolean isReplicaSet() {
        return this instanceof MongoReplicaSet;
    }

    default public MongoProcess asMongoProcess() {
        return (MongoProcess)this;
    }

    default public MongoReplicaSet asMongoReplicaSet() {
        return (MongoReplicaSet)this;
    }

    public ConnectionString getConnectionString(Optional<Database> var1) throws URISyntaxException;

    public ConnectionString getConnectionString(Optional<Database> var1, Optional<Duration> var2) throws URISyntaxException;

    public MongoClient getClient() throws URISyntaxException;

    public MongoClient getClient(Optional<Duration> var1) throws URISyntaxException;

    public ClientSession getClientSession() throws URISyntaxException;

    default public String getMD5Hash(String databaseName) throws URISyntaxException {
        return this.getMD5Hash(this.getMongoDatabase(databaseName));
    }

    public String getMD5Hash(MongoDatabase var1) throws URISyntaxException;

    default public Database getDatabase(String name) {
        return new DatabaseImpl(this, name);
    }

    public boolean equals(Object var1);

    public int hashCode();
}

