/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import com.sap.sse.ServerInfo;
import com.sap.sse.replication.RabbitMQConnectionFactoryHelper;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationServletActions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ReplicationMasterDescriptorImpl
implements ReplicationMasterDescriptor {
    private static final Logger logger = Logger.getLogger(ReplicationMasterDescriptorImpl.class.getName());
    private final String masterServletHostname;
    private final String exchangeName;
    private final int servletPort;
    private final String messagingHostname;
    private final int messagingPort;
    private final String queueName;
    private final String bearerToken;
    private final Iterable<Replicable<?, ?>> replicables;
    private QueueingConsumer consumer;

    public ReplicationMasterDescriptorImpl(String messagingHostname, String exchangeName, int messagingPort, String queueName, String masterServletHostname, int servletPort, String bearerToken, Iterable<Replicable<?, ?>> replicables) {
        this.masterServletHostname = masterServletHostname;
        this.messagingHostname = messagingHostname;
        this.servletPort = servletPort;
        this.messagingPort = messagingPort;
        this.exchangeName = exchangeName;
        this.queueName = queueName;
        this.bearerToken = bearerToken;
        this.consumer = null;
        this.replicables = replicables;
    }

    public URL getReplicationRegistrationRequestURL(UUID uuid, String additional) throws Exception {
        CharSequence[] replicableIdsAsString = (String[])StreamSupport.stream(this.replicables.spliterator(), false).map(r -> r.getId()).toArray(String[]::new);
        return new URL(this.getHttpRequestProtocol(), this.getHostname(), this.servletPort, "/replication/replication?action=" + ReplicationServletActions.Action.REGISTER.name() + "&" + (ServerInfo.getServerInfo().getPort() == null ? "" : "port=" + ServerInfo.getServerInfo().getPort() + "&") + "uuid" + "=" + URLEncoder.encode(uuid.toString(), "UTF-8") + "&" + "additional" + "=" + URLEncoder.encode(ServerInfo.getBuildVersion(), "UTF-8") + "&" + "replicaIdsAsStringsCommaSeparated" + "=" + URLEncoder.encode(String.join((CharSequence)",", replicableIdsAsString), "UTF-8"));
    }

    private String getHttpRequestProtocol() {
        return ReplicationMasterDescriptor.getHttpRequestProtocol((int)this.servletPort);
    }

    public URL getReplicationDeRegistrationRequestURL(UUID uuid) throws MalformedURLException {
        return new URL(this.getHttpRequestProtocol(), this.getHostname(), this.servletPort, "/replication/replication?action=" + ReplicationServletActions.Action.DEREGISTER.name() + "&" + "uuid" + "=" + uuid.toString());
    }

    public Iterable<Replicable<?, ?>> getReplicables() {
        return this.replicables;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exchangeName == null ? 0 : this.exchangeName.hashCode());
        result = 31 * result + (this.masterServletHostname == null ? 0 : this.masterServletHostname.hashCode());
        result = 31 * result + (this.messagingHostname == null ? 0 : this.messagingHostname.hashCode());
        result = 31 * result + this.messagingPort;
        result = 31 * result + this.servletPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicationMasterDescriptorImpl other = (ReplicationMasterDescriptorImpl)obj;
        if (this.exchangeName == null ? other.exchangeName != null : !this.exchangeName.equals(other.exchangeName)) {
            return false;
        }
        if (this.masterServletHostname == null ? other.masterServletHostname != null : !this.masterServletHostname.equals(other.masterServletHostname)) {
            return false;
        }
        if (this.messagingHostname == null ? other.messagingHostname != null : !this.messagingHostname.equals(other.messagingHostname)) {
            return false;
        }
        if (this.messagingPort != other.messagingPort) {
            return false;
        }
        return this.servletPort == other.servletPort;
    }

    public URL getInitialLoadURL(Iterable<Replicable<?, ?>> replicables) throws MalformedURLException {
        String replicablesIdsAsStringSeparatedByCommas = StreamSupport.stream(replicables.spliterator(), false).map(r -> r.getId().toString()).collect(Collectors.joining(","));
        return new URL(this.getHttpRequestProtocol(), this.getHostname(), this.servletPort, "/replication/replication?action=" + ReplicationServletActions.Action.INITIAL_LOAD.name() + "&" + "replicaIdsAsStringsCommaSeparated" + "=" + replicablesIdsAsStringSeparatedByCommas);
    }

    public URL getSendReplicaInitiatedOperationToMasterURL(String replicableIdAsString) throws MalformedURLException {
        return new URL(this.getHttpRequestProtocol(), this.getHostname(), this.servletPort, "/replication/replication");
    }

    public synchronized QueueingConsumer getConsumer() throws IOException, TimeoutException {
        Channel channel = this.createChannel();
        channel.exchangeDeclare(this.exchangeName, "fanout");
        QueueingConsumer consumer = new QueueingConsumer(channel);
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("x-message-ttl", 1800000);
        args.put("x-expires", 3600000);
        args.put("x-max-length", 3000000);
        String queueName = channel.queueDeclare(this.queueName, false, false, false, args).getQueue();
        channel.queueBind(queueName, this.exchangeName, "");
        channel.basicConsume(queueName, false, (Consumer)consumer);
        this.consumer = consumer;
        return consumer;
    }

    public Channel createChannel() throws IOException, TimeoutException {
        ConnectionFactory connectionFactory = RabbitMQConnectionFactoryHelper.getConnectionFactory();
        connectionFactory.setHost(this.getMessagingHostname());
        int port = this.getMessagingPort();
        if (port != 0) {
            connectionFactory.setPort(port);
        }
        Connection connection = connectionFactory.newConnection();
        Channel channel = connection.createChannel();
        return channel;
    }

    public synchronized void stopConnection(boolean deleteExchange) {
        try {
            if (this.consumer != null) {
                this.consumer.getChannel().queueUnbind(this.queueName, this.exchangeName, "");
                this.consumer.getChannel().queueDelete(this.queueName);
                if (deleteExchange) {
                    this.consumer.getChannel().exchangeDelete(this.exchangeName);
                }
                this.consumer.getChannel().getConnection().close(1000);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception while closing replication channel consumer", ex);
        }
    }

    public int getMessagingPort() {
        return this.messagingPort;
    }

    public String getMessagingHostname() {
        return this.messagingHostname;
    }

    public int getServletPort() {
        return this.servletPort;
    }

    public String getHostname() {
        return this.masterServletHostname;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public String toString() {
        return String.valueOf(this.getHostname()) + ":" + this.getServletPort() + " / " + this.getMessagingHostname() + ":" + this.getMessagingPort() + ":" + this.getExchangeName();
    }
}

