/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.racelog.utils;

import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;

public abstract class RaceStateFlagsInterpretationTemplate {
    public String getMeaningOfRaceStateAndFlags(RaceLogRaceStatus status, Flags upperFlag, Flags lowerFlag, boolean isDisplayed) {
        String statusText = "";
        if (status == RaceLogRaceStatus.RUNNING) {
            statusText = this.getTextForRunningRace();
        } else if (status == RaceLogRaceStatus.FINISHING) {
            statusText = this.getTextForFinishingRace();
        } else if (status == RaceLogRaceStatus.FINISHED) {
            statusText = this.getTextForFinishedRace();
        } else if (status == RaceLogRaceStatus.SCHEDULED) {
            statusText = this.getTextForScheduledRace();
        } else if (status == RaceLogRaceStatus.STARTPHASE) {
            statusText = this.getTextForRaceInStartphase();
        } else if (status == RaceLogRaceStatus.UNSCHEDULED || status == RaceLogRaceStatus.PRESCHEDULED) {
            statusText = this.getTextForUnscheduledRace();
            if (upperFlag != null) {
                if (upperFlag == Flags.FIRSTSUBSTITUTE) {
                    statusText = this.getTextForFirstSubstituteFlag();
                } else if (upperFlag == Flags.AP && lowerFlag == Flags.ALPHA && isDisplayed) {
                    statusText = this.getTextForAnsweringPennantWithAlphaFlags();
                } else if (upperFlag == Flags.AP && lowerFlag == Flags.HOTEL && isDisplayed) {
                    statusText = this.getTextForAnsweringPennantWithHotelFlags();
                } else if (upperFlag == Flags.AP && isDisplayed) {
                    statusText = this.getTextForAnsweringPennantFlag();
                } else if (upperFlag == Flags.NOVEMBER && lowerFlag == Flags.ALPHA && isDisplayed) {
                    statusText = this.getTextForNovemberWithAlphaFlags();
                } else if (upperFlag == Flags.NOVEMBER && lowerFlag == Flags.HOTEL && isDisplayed) {
                    statusText = this.getTextForNovemberWithHotelFlags();
                } else if (upperFlag == Flags.NOVEMBER && isDisplayed) {
                    statusText = this.getTextForNovemberFlag();
                }
            }
        }
        return statusText;
    }

    protected abstract String getTextForRunningRace();

    protected abstract String getTextForFinishingRace();

    protected abstract String getTextForFinishedRace();

    protected abstract String getTextForScheduledRace();

    protected abstract String getTextForRaceInStartphase();

    protected abstract String getTextForUnscheduledRace();

    protected abstract String getTextForFirstSubstituteFlag();

    protected abstract String getTextForAnsweringPennantFlag();

    protected abstract String getTextForAnsweringPennantWithAlphaFlags();

    protected abstract String getTextForAnsweringPennantWithHotelFlags();

    protected abstract String getTextForNovemberFlag();

    protected abstract String getTextForNovemberWithAlphaFlags();

    protected abstract String getTextForNovemberWithHotelFlags();
}

