/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.BasicRaceDTO;
import com.sap.sailing.domain.common.dto.PlacemarkOrderDTO;
import com.sap.sailing.domain.common.dto.RaceStatusDTO;
import com.sap.sailing.domain.common.dto.TrackedRaceDTO;
import com.sap.sailing.domain.common.dto.TrackedRaceStatisticsDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;

public class RaceDTO
extends BasicRaceDTO
implements SecuredDTO {
    private static final long serialVersionUID = 2613189982608149975L;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    public boolean isTracked;
    public RaceStatusDTO status;
    public PlacemarkOrderDTO places;
    public TrackedRaceStatisticsDTO trackedRaceStatistics;
    public String boatClass;
    private RankingMetrics rankingMetricType;
    private RegattaAndRaceIdentifier raceIdentifier;

    @Deprecated
    public RaceDTO() {
    }

    public RaceDTO(RegattaAndRaceIdentifier raceIdentifier, TrackedRaceDTO trackedRace, boolean isCurrentlyTracked, RankingMetrics rankingMetricType) {
        super(raceIdentifier, trackedRace);
        this.raceIdentifier = raceIdentifier;
        this.isTracked = isCurrentlyTracked;
        this.rankingMetricType = rankingMetricType;
    }

    public RegattaAndRaceIdentifier getRaceIdentifier() {
        return this.raceIdentifier;
    }

    public RankingMetrics getRankingMetricType() {
        return this.rankingMetricType;
    }

    public String getRegattaName() {
        return this.raceIdentifier.getRegattaName();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.boatClass == null ? 0 : this.boatClass.hashCode());
        result = 31 * result + (this.isTracked ? 1231 : 1237);
        result = 31 * result + (this.places == null ? 0 : this.places.hashCode());
        result = 31 * result + (this.getRegattaName() == null ? 0 : this.getRegattaName().hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RaceDTO other = (RaceDTO)((Object)obj);
        if (this.boatClass == null ? other.boatClass != null : !this.boatClass.equals(other.boatClass)) {
            return false;
        }
        if (this.isTracked != other.isTracked) {
            return false;
        }
        if (this.places == null ? other.places != null : !this.places.equals(other.places)) {
            return false;
        }
        if (this.getRegattaName() == null ? other.getRegattaName() != null : !this.getRegattaName().equals(other.getRegattaName())) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    public final AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    public final OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    public final void setAccessControlList(AccessControlListDTO accessControlList) {
        this.securityInformation.setAccessControlList(accessControlList);
    }

    public final void setOwnership(OwnershipDTO ownership) {
        this.securityInformation.setOwnership(ownership);
    }

    public HasPermissions getPermissionType() {
        return RaceDTO.getPermissionTypeForClass();
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public static HasPermissions getPermissionTypeForClass() {
        return SecuredDomainType.TRACKED_RACE;
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(RegattaAndRaceIdentifier raceIdentifier) {
        return raceIdentifier.getTypeRelativeObjectIdentifier();
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return RaceDTO.getTypeRelativeObjectIdentifier(this.raceIdentifier);
    }
}

