/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.aws.AwsAutoScalingGroup;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.ssh.JCraftLogAdapter;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import com.sap.sse.landscape.ssh.SshCommandChannelImpl;
import com.sap.sse.landscape.ssh.YesUserInfo;
import com.sap.sse.shared.util.Wait;
import java.net.InetAddress;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Tag;

public class AwsInstanceImpl<ShardingKey>
implements AwsInstance<ShardingKey> {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(AwsInstanceImpl.class.getName());
    private static final String ROOT_USER_NAME = "root";
    private final String instanceId;
    private final AwsAvailabilityZone availabilityZone;
    private final InetAddress privateAddress;
    private InetAddress publicAddress;
    private final TimePoint launchTimePoint;
    private final AwsLandscape<ShardingKey> landscape;
    private String name;
    private String imageId;

    public AwsInstanceImpl(String instanceId, AwsAvailabilityZone availabilityZone, InetAddress privateAddress, TimePoint launchTimePoint, AwsLandscape<ShardingKey> landscape) {
        this.instanceId = instanceId;
        this.availabilityZone = availabilityZone;
        this.privateAddress = privateAddress;
        this.launchTimePoint = launchTimePoint;
        this.landscape = landscape;
    }

    public boolean equals(Object other) {
        return ((AwsInstance)other).getInstanceId().equals(this.getInstanceId());
    }

    public int hashCode() {
        return this.getInstance().hashCode();
    }

    public TimePoint getLaunchTimePoint() {
        return this.launchTimePoint;
    }

    public InetAddress getPublicAddress() {
        if (this.publicAddress == null) {
            try {
                this.publicAddress = this.getPublicAddress(Optional.of(Duration.NULL));
            }
            catch (TimeoutException e) {
                logger.info("Couldn't get public address of instance " + this.getId());
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicAddress;
    }

    public InetAddress getPublicAddress(Optional<Duration> timeoutEmptyMeaningForever) throws TimeoutException, Exception {
        if (this.publicAddress == null) {
            String publicIpAddress;
            Instance instance = this.getInstance();
            this.publicAddress = instance.state().name() == InstanceStateName.RUNNING || instance.state().name() == InstanceStateName.PENDING ? ((publicIpAddress = (String)Wait.wait(() -> this.getInstance().publicIpAddress(), ipAddress -> ipAddress != null, (boolean)false, timeoutEmptyMeaningForever, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for public IP address of instance " + instance.instanceId()))) == null ? null : InetAddress.getByName(publicIpAddress)) : null;
        }
        return this.publicAddress;
    }

    public String getNameTag() {
        String result = "No name tag found";
        if (this.name == null) {
            Instance instance = this.getInstance();
            for (Tag tag : instance.tags()) {
                if (!tag.key().equals("Name")) continue;
                result = this.name = tag.value();
                break;
            }
        } else {
            result = this.name;
        }
        return result;
    }

    public String getImageId() {
        String result;
        if (this.imageId == null) {
            Instance instance = this.getInstance();
            result = this.imageId = instance.imageId();
        } else {
            result = this.imageId;
        }
        return result;
    }

    public InetAddress getPrivateAddress() {
        return this.privateAddress;
    }

    public InetAddress getPrivateAddress(Optional<Duration> timeoutEmptyMeaningForever) {
        return this.getPrivateAddress();
    }

    public String getHostname() {
        String privateIpAddress = this.getPrivateAddress().getHostAddress();
        return this.getHostnameForPrivateAddress(privateIpAddress);
    }

    public String getHostname(Optional<Duration> timeoutEmptyMeaningForever) {
        String privateIpAddress = this.getPrivateAddress(timeoutEmptyMeaningForever).getHostAddress();
        return this.getHostnameForPrivateAddress(privateIpAddress);
    }

    private String getHostnameForPrivateAddress(String privateIpAddress) {
        String hostname;
        String result = privateIpAddress == null ? null : ((hostname = this.landscape.findHostnamesForIP(privateIpAddress)) == null ? privateIpAddress : hostname);
        return result;
    }

    public Session createRootSshSession(Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws TimeoutException, Exception {
        return this.createSshSession(ROOT_USER_NAME, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    public Session createSshSession(String sshUserName, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws JSchException {
        String keyName = optionalKeyName.orElseGet(() -> this.getInstance().keyName());
        SSHKeyPair keyPair = this.landscape.getSSHKeyPair(this.getRegion(), keyName);
        if (keyPair == null) {
            throw new IllegalStateException("Couldn't find key pair " + keyName + " in landscape.");
        }
        JSch jsch = new JSch();
        JSch.setLogger((Logger)new JCraftLogAdapter());
        jsch.addIdentity(keyName, keyPair.getEncryptedPrivateKey(), keyPair.getPublicKey(), privateKeyEncryptionPassphrase);
        InetAddress address = this.getPublicAddress();
        if (address == null) {
            throw new IllegalStateException("Instance " + this.getInstanceId() + " doesn't have a public IP address");
        }
        return jsch.getSession(sshUserName, address.getHostAddress());
    }

    public SshCommandChannel createRootSshChannel(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.createSshChannel(ROOT_USER_NAME, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    public SshCommandChannel createSshChannel(String sshUserName, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        ChannelExec channelExec = (ChannelExec)this.createSshChannelInternal(sshUserName, "exec", optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        return channelExec == null ? null : new SshCommandChannelImpl(channelExec);
    }

    private Channel createSshChannelInternal(String sshUserName, String channelType, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        Channel result;
        logger.info("Creating SSH " + channelType + " channel for SSH user " + sshUserName + " with key " + optionalKeyName + " to instance with ID " + this.getInstanceId());
        if (!optionalKeyName.isPresent() && !Util.hasLength((String)this.getInstance().keyName())) {
            logger.severe("SSH connection to " + this + " cannot be made because no key name is provided, neither explicitly nor during start-up");
            result = null;
        } else {
            try {
                result = (Channel)Wait.wait(() -> {
                    Session session = null;
                    try {
                        session = this.createSshSession(sshUserName, optionalKeyName, privateKeyEncryptionPassphrase);
                        session.setUserInfo((UserInfo)new YesUserInfo());
                        session.connect(optionalTimeout.map(d -> d.asMillis()).orElse(0L).intValue());
                        return session.openChannel(channelType);
                    }
                    catch (JSchException | IllegalStateException e) {
                        if (session != null) {
                            session.disconnect();
                        }
                        throw e;
                    }
                }, channel -> channel != null, (boolean)true, optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Trying to connect to " + this.getInstanceId() + " with user " + sshUserName + " using SSH"));
            }
            catch (TimeoutException timeout) {
                result = null;
            }
        }
        return result;
    }

    public ChannelSftp createSftpChannel(String sshUserName, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return (ChannelSftp)this.createSshChannelInternal(sshUserName, "sftp", optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    public ChannelSftp createRootSftpChannel(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.createSftpChannel(ROOT_USER_NAME, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    @Override
    public AwsAvailabilityZone getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Override
    public InstanceType getInstanceType() {
        return this.getInstance().instanceType();
    }

    public Iterable<SecurityGroup> getSecurityGroups() {
        return Util.map((Iterable)this.getInstance().securityGroups(), groupIdentifier -> this.landscape.getSecurityGroup(groupIdentifier.groupId(), this.getRegion()));
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public void terminate() {
        this.landscape.terminate(this);
    }

    @Override
    public AwsLandscape<ShardingKey> getLandscape() {
        return this.landscape;
    }

    @Override
    public boolean isManagedByAutoScalingGroup() {
        return this.getInstance().tags().stream().filter(tag -> tag.key().equals("aws:autoscaling:groupName")).findAny().isPresent();
    }

    @Override
    public boolean isManagedByAutoScalingGroup(Iterable<AwsAutoScalingGroup> autoScalingGroups) {
        return this.getInstance().tags().stream().filter(tag -> tag.key().equals("aws:autoscaling:groupName") && Util.stream((Iterable)autoScalingGroups).filter(autoScalingGroup -> autoScalingGroup.getName().equals(tag.value())).findAny().isPresent()).findAny().isPresent();
    }

    public String toString() {
        return this.getInstanceId();
    }

    @Override
    public boolean verifySshKey(Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) {
        String keyName = optionalKeyName.orElseGet(() -> this.getInstance().keyName());
        SSHKeyPair keyPair = this.landscape.getSSHKeyPair(this.getRegion(), keyName);
        if (keyPair == null) {
            return false;
        }
        JSch jsch = new JSch();
        return keyPair.checkPassphrase(jsch, privateKeyEncryptionPassphrase);
    }
}

