/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.common.Util;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.util.ThreadPoolUtil;
import com.sap.sse.util.impl.HasTracingGet;
import com.sap.sse.util.impl.HasTracingGetImpl;
import com.sap.sse.util.impl.KnowsExecutor;
import com.sap.sse.util.impl.KnowsExecutorAndTracingGet;
import com.sap.sse.util.impl.KnowsExecutorAndTracingGetImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SmartFutureCache<K, V, U extends UpdateInterval<U>> {
    private static final Logger logger = Logger.getLogger(SmartFutureCache.class.getName());
    private final ConcurrentMap<K, FutureTaskWithCancelBlocking> ongoingRecalculations = new ConcurrentHashMap<K, FutureTaskWithCancelBlocking>();
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private static final Executor recalculator = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();
    private final CacheUpdater<K, V, U> cacheUpdateComputer;
    private final ConcurrentMap<K, NamedReentrantReadWriteLock> locksForKeys;
    private final String nameForLocks;
    private boolean suspended;
    private final Map<K, Util.Pair<U, Set<SettableFuture<Future<V>>>>> triggeredAndNotYetScheduled;
    private int smartFutureCacheTaskReuseCounter;

    public SmartFutureCache(CacheUpdater<K, V, U> cacheUpdateComputer, String nameForLocks) {
        this.cacheUpdateComputer = cacheUpdateComputer;
        this.locksForKeys = new ConcurrentHashMap<K, NamedReentrantReadWriteLock>();
        this.nameForLocks = nameForLocks;
        this.triggeredAndNotYetScheduled = new HashMap<K, Util.Pair<U, Set<SettableFuture<Future<V>>>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedReentrantReadWriteLock getOrCreateLockForKey(K key) {
        ConcurrentMap<K, NamedReentrantReadWriteLock> concurrentMap = this.locksForKeys;
        synchronized (concurrentMap) {
            NamedReentrantReadWriteLock result = (NamedReentrantReadWriteLock)this.locksForKeys.get(key);
            if (result == null) {
                result = new NamedReentrantReadWriteLock(String.valueOf(this.nameForLocks) + " for key " + key, false);
                this.locksForKeys.put(key, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        logger.finest("suspending cache " + this.nameForLocks);
        ConcurrentMap<K, FutureTaskWithCancelBlocking> concurrentMap = this.ongoingRecalculations;
        synchronized (concurrentMap) {
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ConcurrentMap<K, FutureTaskWithCancelBlocking> concurrentMap = this.ongoingRecalculations;
        synchronized (concurrentMap) {
            this.suspended = false;
            logger.finest("resuming cache " + this.nameForLocks);
            Iterator<Map.Entry<K, Util.Pair<U, Set<SettableFuture<Future<V>>>>>> i = this.triggeredAndNotYetScheduled.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<K, Util.Pair<U, Set<SettableFuture<Future<V>>>>> e = i.next();
                logger.finest(() -> "while resuming " + this.nameForLocks + ", triggering update for key " + e.getKey() + " with update interval " + e.getValue());
                this.triggerUpdate(e.getKey(), (UpdateInterval)e.getValue().getA());
                i.remove();
            }
        }
    }

    private void queue(K key, U updateInterval, SettableFuture<Future<V>> setWhenDone) {
        Util.Pair<U, Set<SettableFuture<Future<V>>>> oldUpdateInterval = this.triggeredAndNotYetScheduled.get(key);
        Object joinedUpdateInterval = this.joinUpdateIntervals(updateInterval, oldUpdateInterval == null ? null : (UpdateInterval)oldUpdateInterval.getA());
        HashSet<SettableFuture<Future<V>>> newSetWhenDone = new HashSet<SettableFuture<Future<V>>>();
        if (oldUpdateInterval != null) {
            newSetWhenDone.addAll((Collection)oldUpdateInterval.getB());
        }
        if (setWhenDone != null) {
            newSetWhenDone.add(setWhenDone);
        }
        this.triggeredAndNotYetScheduled.put(key, new Util.Pair(joinedUpdateInterval, newSetWhenDone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerUpdate(K key, U updateInterval) {
        ConcurrentMap<K, FutureTaskWithCancelBlocking> concurrentMap = this.ongoingRecalculations;
        synchronized (concurrentMap) {
            if (this.suspended) {
                this.queue(key, updateInterval, null);
            } else {
                this.scheduleRecalculationIfNotScheduledOrRunningOtherwiseUpdateScheduledTaskOrQueueIfAlreadyRunning(key, updateInterval, false);
            }
        }
    }

    private U joinUpdateIntervals(U updateInterval, U oldUpdateInterval) {
        U joinedUpdateInterval = oldUpdateInterval == null ? updateInterval : (updateInterval == null ? oldUpdateInterval : updateInterval.join(oldUpdateInterval));
        return joinedUpdateInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<V> scheduleRecalculationIfNotScheduledOrRunningOtherwiseUpdateScheduledTaskOrQueueIfAlreadyRunning(K key, U updateInterval, boolean callerWaitsSynchronouslyForResult) {
        Future<Object> result;
        ConcurrentMap<K, FutureTaskWithCancelBlocking> concurrentMap = this.ongoingRecalculations;
        synchronized (concurrentMap) {
            if (this.ongoingRecalculations.containsKey(key)) {
                FutureTaskWithCancelBlocking scheduledOrRunning = (FutureTaskWithCancelBlocking)this.ongoingRecalculations.get(key);
                boolean reuseExistingFuture = scheduledOrRunning.tryToUpdateUpdateInterval(updateInterval);
                if (reuseExistingFuture) {
                    result = scheduledOrRunning;
                    ++this.smartFutureCacheTaskReuseCounter;
                } else {
                    SettableFuture<Future<V>> nestedFuture;
                    if (callerWaitsSynchronouslyForResult) {
                        nestedFuture = new SettableFuture<Future<V>>();
                        result = new TransitiveFuture(nestedFuture);
                    } else {
                        nestedFuture = null;
                        result = null;
                    }
                    this.queue(key, updateInterval, nestedFuture);
                }
            } else {
                result = this.schedule(key, updateInterval, callerWaitsSynchronouslyForResult);
            }
        }
        return result;
    }

    private Future<V> schedule(K key, U joinedUpdateInterval, boolean callerWaitsSynchronouslyForResult) {
        Thread callerThread = Thread.currentThread();
        FutureTaskWithCancelBlocking future = new FutureTaskWithCancelBlocking(this, key, joinedUpdateInterval, callerWaitsSynchronouslyForResult, callerThread);
        this.ongoingRecalculations.put(key, future);
        recalculator.execute(future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, boolean waitForLatest) {
        V value;
        if (waitForLatest) {
            Future<V> future;
            ConcurrentMap<K, FutureTaskWithCancelBlocking> concurrentMap = this.ongoingRecalculations;
            synchronized (concurrentMap) {
                Util.Pair<U, Set<SettableFuture<Future<V>>>> triggeredSinceLastCacheUpdate = this.triggeredAndNotYetScheduled.remove(key);
                future = triggeredSinceLastCacheUpdate != null ? this.scheduleRecalculationIfNotScheduledOrRunningOtherwiseUpdateScheduledTaskOrQueueIfAlreadyRunning(key, (UpdateInterval)triggeredSinceLastCacheUpdate.getA(), true) : (Future<V>)this.ongoingRecalculations.get(key);
            }
            try {
                if (future != null) {
                    value = future.get();
                }
                value = this.readCache(key);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.log(Level.SEVERE, "get", e);
                throw new RuntimeException(e);
            }
        } else {
            value = this.readCache(key);
        }
        return value;
    }

    private V readCache(K key) {
        Object value;
        NamedReentrantReadWriteLock lock = this.getOrCreateLockForKey(key);
        LockUtil.lockForRead((NamedReentrantReadWriteLock)lock);
        try {
            value = this.cache.get(key);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)lock);
        }
        return value;
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    protected void cache(K key, V value) {
        if (value == null) {
            this.cache.remove(key);
            this.locksForKeys.remove(key);
        } else {
            this.cache.put(key, value);
        }
    }

    public int getSmartFutureCacheTaskReuseCounter() {
        return this.smartFutureCacheTaskReuseCounter;
    }

    public void remove(K key) {
        this.cache(key, null);
    }

    static /* synthetic */ ConcurrentMap access$0(SmartFutureCache smartFutureCache) {
        return smartFutureCache.ongoingRecalculations;
    }

    static /* synthetic */ Map access$1(SmartFutureCache smartFutureCache) {
        return smartFutureCache.triggeredAndNotYetScheduled;
    }

    static /* synthetic */ boolean access$2(SmartFutureCache smartFutureCache) {
        return smartFutureCache.suspended;
    }

    static /* synthetic */ Future access$3(SmartFutureCache smartFutureCache, Object object, UpdateInterval updateInterval, boolean bl) {
        return smartFutureCache.schedule(object, updateInterval, bl);
    }

    static /* synthetic */ NamedReentrantReadWriteLock access$5(SmartFutureCache smartFutureCache, Object object) {
        return smartFutureCache.getOrCreateLockForKey(object);
    }

    static /* synthetic */ ConcurrentMap access$6(SmartFutureCache smartFutureCache) {
        return smartFutureCache.cache;
    }

    static /* synthetic */ Logger access$7() {
        return logger;
    }

    public static abstract class AbstractCacheUpdater<K, V, U extends UpdateInterval<U>>
    implements CacheUpdater<K, V, U> {
        @Override
        public V provideNewCacheValue(K key, V oldCacheValue, V computedCacheUpdate, U updateInterval) {
            return computedCacheUpdate;
        }
    }

    public static interface CacheUpdater<K, V, U extends UpdateInterval<U>> {
        public V computeCacheUpdate(K var1, U var2) throws Exception;

        public V provideNewCacheValue(K var1, V var2, V var3, U var4);
    }

    public static class EmptyUpdateInterval
    implements UpdateInterval<EmptyUpdateInterval> {
        @Override
        public EmptyUpdateInterval join(EmptyUpdateInterval otherUpdateInterval) {
            return null;
        }
    }

    private static class FutureTaskWithCancelBlocking
    extends FutureTask<V>
    implements KnowsExecutor,
    Callable<V> {
        private final KnowsExecutorAndTracingGet<V> tracingGetHelper;
        private boolean runningAndReadUpdateInterval;
        private final K key;
        private U updateInterval;
        private final boolean callerWaitsSynchronouslyForResult;
        private final Thread callerThread;
        private Thread executingThread;
        private Set<Thread> gettingThreads;
        final /* synthetic */ SmartFutureCache this$0;

        public FutureTaskWithCancelBlocking(K key, U updateInterval, boolean callerWaitsSynchronouslyForResult, Thread callerThread) {
            this(var1_1, new SettableCallable(), key, (UpdateInterval)updateInterval, callerWaitsSynchronouslyForResult, callerThread);
        }

        public FutureTaskWithCancelBlocking(SettableCallable<V> callable, K key, U updateInterval, boolean callerWaitsSynchronouslyForResult, Thread callerThread) {
            this.this$0 = var1_1;
            super(ThreadPoolUtil.INSTANCE.associateWithSubjectIfAny(callable));
            this.tracingGetHelper = new KnowsExecutorAndTracingGetImpl();
            callable.setCallable(this);
            this.gettingThreads = new HashSet<Thread>();
            this.key = key;
            this.updateInterval = updateInterval;
            this.callerWaitsSynchronouslyForResult = callerWaitsSynchronouslyForResult;
            this.callerThread = callerThread;
        }

        public synchronized boolean tryToUpdateUpdateInterval(U newUpdateInterval) {
            boolean result;
            if (this.runningAndReadUpdateInterval) {
                result = false;
            } else {
                result = true;
                this.updateInterval = newUpdateInterval;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            FutureTaskWithCancelBlocking futureTaskWithCancelBlocking = this;
            synchronized (futureTaskWithCancelBlocking) {
                boolean callHasTerminatedWhenGetWasCalled;
                Thread propagatedToExecutingThread = this.executingThread;
                boolean bl = callHasTerminatedWhenGetWasCalled = this.runningAndReadUpdateInterval && propagatedToExecutingThread == null;
                if (!callHasTerminatedWhenGetWasCalled) {
                    this.gettingThreads.add(Thread.currentThread());
                    if (propagatedToExecutingThread != null) {
                        LockUtil.propagateLockSetTo((Thread)propagatedToExecutingThread);
                    }
                }
            }
            return this.tracingGetHelper.callGetAndTraceAfterEachTimeout(this);
        }

        /*
         * Exception decompiling
         */
        @Override
        public V call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public U getUpdateInterval() {
            return this.updateInterval;
        }

        @Override
        public void setExecutorThisTaskIsScheduledFor(ThreadPoolExecutor executorThisTaskIsScheduledFor) {
            this.tracingGetHelper.setExecutorThisTaskIsScheduledFor(executorThisTaskIsScheduledFor);
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getName()) + " [key=" + this.key + ", updateInterval=" + this.updateInterval + ", cacheUpdateComputer=" + this.this$0.cacheUpdateComputer + "]";
        }
    }

    private static class SettableCallable<V>
    implements Callable<V> {
        private Callable<V> callable;

        private SettableCallable() {
        }

        public void setCallable(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }

        public String toString() {
            return this.callable == null ? "null" : this.callable.toString();
        }
    }

    private static class SettableFuture<T>
    implements Future<T> {
        private T value;
        private boolean isSet;

        private SettableFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.isSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                while (!this.isSet) {
                    this.wait();
                }
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                while (!this.isSet) {
                    this.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
                    if (this.isSet) continue;
                    throw new TimeoutException();
                }
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(T value) {
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                this.value = value;
                this.isSet = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            String result;
            SettableFuture settableFuture = this;
            synchronized (settableFuture) {
                result = this.isSet ? (this.value == null ? "null" : this.value.toString()) : "unset";
            }
            return result;
        }
    }

    private static class TransitiveFuture<T>
    implements Future<T> {
        private final SettableFuture<Future<T>> future;
        private final HasTracingGet<T> tracingGetHelper;

        protected TransitiveFuture(SettableFuture<Future<T>> future) {
            this.future = future;
            this.tracingGetHelper = new HasTracingGetImpl<T>(){

                @Override
                protected String getAdditionalTraceInfo() {
                    return "transitive future " + future.toString();
                }
            };
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                return this.future.get().cancel(mayInterruptIfRunning);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isCancelled() {
            try {
                return this.future.get().isCancelled();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isDone() {
            try {
                return this.future.get().isDone();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.tracingGetHelper.callGetAndTraceAfterEachTimeout(this);
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit).get(timeout, unit);
        }
    }

    public static interface UpdateInterval<U extends UpdateInterval<U>> {
        public U join(U var1);
    }
}

